/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.compat;

import xaero.lib.client.compat.ClientModCompatibility;
import xaero.lib.common.compat.PlatformModCompatibility;
import xaero.lib.common.compat.ftbranks.FTBRanksCompat;
import xaero.lib.common.compat.luckperms.LuckPermsCompat;
import xaero.lib.common.permission.system.PermissionSystemRegistry;
import xaero.lib.platform.Services;

public class ModCompatibility {
    private static ModCompatibility instance;
    private FTBRanksCompat ftbRanks;
    private LuckPermsCompat luckPerms;
    private PlatformModCompatibility platform;

    public static ModCompatibility getInstance() {
        if (instance == null) {
            instance = Services.PLATFORM.isDedicatedServer() ? new ModCompatibility() : new ClientModCompatibility();
        }
        return instance;
    }

    protected ModCompatibility() {
        try {
            Class.forName("dev.ftb.mods.ftbranks.api.FTBRanksAPI");
            this.ftbRanks = new FTBRanksCompat();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("net.luckperms.api.LuckPerms");
            this.luckPerms = new LuckPermsCompat();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.platform = Services.PLATFORM.createPlatformModCompatibility();
    }

    public boolean hasFTBRanks() {
        return this.ftbRanks != null;
    }

    public boolean hasLuckPerms() {
        return this.luckPerms != null;
    }

    public FTBRanksCompat getFtbRanks() {
        return this.ftbRanks;
    }

    public LuckPermsCompat getLuckPerms() {
        return this.luckPerms;
    }

    public void registerPermissionSystems() {
        if (this.hasFTBRanks()) {
            PermissionSystemRegistry.INSTANCE.register(this.ftbRanks.createPermissionSystem());
        }
        if (this.hasLuckPerms()) {
            PermissionSystemRegistry.INSTANCE.register(this.luckPerms.createPermissionSystem());
        }
        this.platform.registerPermissionSystems();
    }

    public void freeze() {
        this.platform.freeze();
    }
}

