/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.shaders.UniformType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuSampler;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.rendertype.LayeringTransform;
import net.minecraft.client.renderer.rendertype.OutputTarget;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.TextureTransform;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Util;
import xaero.lib.client.graphics.IRenderSetup;
import xaero.lib.client.graphics.ITextureBinding;
import xaero.lib.client.graphics.shader.BuiltInCustomUniforms;
import xaero.lib.client.graphics.shader.LibShaders;
import xaero.lib.common.reflection.util.ReflectionUtils;

public class XaeroRenderType {
    public static final VertexFormat POSITION_COLOR_TEX = VertexFormat.builder().add("Position", VertexFormatElement.POSITION).add("Color", VertexFormatElement.COLOR).add("UV0", VertexFormatElement.UV0).build();
    protected static final BlendFunction DEFAULT_TRANSLUCENT_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA);
    protected static final BlendFunction LINES_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA);
    protected static final BlendFunction PREMULTIPLIED_TRANSPARENCY = new BlendFunction(SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA);
    protected static final BlendFunction NEGATIVE_TRANSPARENCY = new BlendFunction(SourceFactor.ONE_MINUS_DST_COLOR, DestFactor.ZERO, SourceFactor.ZERO, DestFactor.ONE);
    protected static final BlendFunction DEST_TRANSPARENCY = new BlendFunction(SourceFactor.ONE, DestFactor.ZERO, SourceFactor.ZERO, DestFactor.ONE);
    protected static final BlendFunction REPLACE_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ZERO, SourceFactor.ONE, DestFactor.ZERO);
    protected static final BlendFunction ADD_ALPHA_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE);
    protected static final BiFunction<FilterMode, FilterMode, GpuSampler> SIMPLER_SAMPLER = Util.memoize((minFilter, magFilter) -> RenderSystem.getDevice().createSampler(AddressMode.CLAMP_TO_EDGE, AddressMode.CLAMP_TO_EDGE, minFilter, magFilter, 1, OptionalDouble.of(1.0)));
    public static final RenderPipeline RP_POSITION_TEX_ALPHA;
    public static final RenderPipeline RP_POSITION_TEX_ALPHA_NO_BLEND;
    public static final RenderPipeline RP_POSITION_TEX_NO_ALPHA;
    public static final RenderPipeline RP_POSITION_TEX_NO_ALPHA_NO_DEPTH;
    public static final RenderPipeline RP_POSITION_TEX_NO_ALPHA_NO_BLEND;
    public static final RenderPipeline RP_POSITION_TEX_ALPHA_REPLACE;
    public static final RenderPipeline RP_POSITION_TEX_ALPHA_NO_CULL;
    public static final RenderPipeline RP_POSITION;
    public static final RenderPipeline RP_POSITION_NO_DEPTH;
    public static final RenderPipeline RP_NEGATIVE_COLOR;
    public static final RenderPipeline RP_ICON_OUTLINE;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_TRANSLUCENT;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_TRANSLUCENT_NO_DEPTH;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_TRANSLUCENT_CULL;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_PREMULTIPLIED;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_NO_BLEND;
    public static final RenderPipeline RP_POSITION_COLOR_TRANSLUCENT;
    public static final RenderPipeline RP_POSITION_COLOR_NO_BLEND;
    public static final RenderPipeline RP_POSITION_COLOR_NO_CULL;
    public static final RenderPipeline RP_LINES;
    public static final RenderPipeline RP_DEPTH_CLEAR;
    public static final RenderPipeline RP_MAP;
    public static final RenderPipeline RP_MAP_BRANCH;
    public static final RenderPipeline RP_MAP_FRAME;
    public static final RenderPipeline RP_COLOR_FILLER;
    private static final Method renderTypeCreateMethod;

    public static RenderType createRenderType(String name, RenderSetup.RenderSetupBuilder renderSetupBuilder) {
        RenderSetup renderSetup = renderSetupBuilder.createRenderSetup();
        return (RenderType)ReflectionUtils.getReflectMethodValue(null, renderTypeCreateMethod, name, renderSetup);
    }

    public static GpuSampler getSimpleSampler(FilterMode filterMode) {
        return SIMPLER_SAMPLER.apply(filterMode, filterMode);
    }

    public static GpuSampler getSimpleSampler(FilterMode minFilter, FilterMode magFilter) {
        return SIMPLER_SAMPLER.apply(minFilter, magFilter);
    }

    public static RenderPipeline getBasicRenderPipeline() {
        return RenderPipelines.ENTITY_TRANSLUCENT;
    }

    public static RenderTarget getOutputStateTarget(Object outputStateShard) {
        return ((OutputTarget)outputStateShard).getRenderTarget();
    }

    public static Map<String, ITextureBinding> getSetupTextures(RenderSetup setup) {
        return ((IRenderSetup)setup).xaero_lib_getTextures();
    }

    public static TextureTransform getSetupTextureTransform(RenderSetup setup) {
        return ((IRenderSetup)setup).xaero_lib_getTextureTransform();
    }

    public static boolean getSetupUseOverlay(RenderSetup setup) {
        return ((IRenderSetup)setup).xaero_lib_getUseOverlay();
    }

    public static LayeringTransform getSetupLayeringTransform(RenderSetup setup) {
        return ((IRenderSetup)setup).xaero_lib_getLayeringTransform();
    }

    static {
        renderTypeCreateMethod = ReflectionUtils.getMethodReflection(RenderType.class, "create", "method_75940", "(Ljava/lang/String;Lnet/minecraft/class_12247;)Lnet/minecraft/class_1921;", "", String.class, RenderSetup.class);
        RenderPipeline.Snippet MATRICES_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[0]).withUniform("DynamicTransforms", UniformType.UNIFORM_BUFFER).withUniform("Projection", UniformType.UNIFORM_BUFFER).buildSnippet();
        RenderPipeline.Snippet MATRICES_FOG_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withUniform("Fog", UniformType.UNIFORM_BUFFER).buildSnippet();
        RenderPipeline.Snippet POSITION_TEX_NO_ALPHA_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(LibShaders.POSITION_TEX_NO_ALPHA_TEST).withFragmentShader(LibShaders.POSITION_TEX_NO_ALPHA_TEST).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).withSampler("Sampler0").buildSnippet();
        RP_POSITION_TEX_NO_ALPHA = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_TEX_NO_ALPHA_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_tex_no_alpha")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).build();
        RP_POSITION_TEX_NO_ALPHA_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_TEX_NO_ALPHA_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_tex_no_alpha_no_depth")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        RP_POSITION_TEX_NO_ALPHA_NO_BLEND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_TEX_NO_ALPHA_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_tex_no_alpha_no_blend")).withoutBlend().build();
        RenderPipeline.Snippet RP_POSITION_TEX_ALPHA_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(LibShaders.POSITION_TEX_ALPHA_TEST).withFragmentShader(LibShaders.POSITION_TEX_ALPHA_TEST).withUniform(BuiltInCustomUniforms.DISCARD_ALPHA.name(), BuiltInCustomUniforms.DISCARD_ALPHA.type()).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).withSampler("Sampler0").buildSnippet();
        RP_POSITION_TEX_ALPHA = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_tex_alpha")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).build();
        RP_ICON_OUTLINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/icon_outline")).withBlend(ADD_ALPHA_TRANSPARENCY).build();
        RP_POSITION_TEX_ALPHA_NO_BLEND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_tex_alpha_no_blend")).withoutBlend().build();
        RP_POSITION_TEX_ALPHA_REPLACE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_tex_alpha_replace")).withBlend(REPLACE_TRANSPARENCY).build();
        RP_POSITION_TEX_ALPHA_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_tex_alpha_no_cull")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withCull(false).build();
        RP_POSITION = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos")).withVertexShader("core/position").withFragmentShader("core/position").withVertexFormat(DefaultVertexFormat.POSITION, VertexFormat.Mode.QUADS).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).build();
        RP_POSITION_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos")).withVertexShader("core/position").withFragmentShader("core/position").withVertexFormat(DefaultVertexFormat.POSITION, VertexFormat.Mode.QUADS).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        RP_NEGATIVE_COLOR = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_negative_color")).withVertexShader("core/position").withFragmentShader("core/position").withVertexFormat(DefaultVertexFormat.POSITION, VertexFormat.Mode.QUADS).withBlend(NEGATIVE_TRANSPARENCY).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        RenderPipeline.Snippet POSITION_COLOR_TEX_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(LibShaders.POSITION_COLOR_TEX).withFragmentShader(LibShaders.POSITION_COLOR_TEX).withVertexFormat(POSITION_COLOR_TEX, VertexFormat.Mode.QUADS).withSampler("Sampler0").buildSnippet();
        RenderPipeline.Snippet POSITION_COLOR_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(LibShaders.POSITION_COLOR).withFragmentShader(LibShaders.POSITION_COLOR).withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS).buildSnippet();
        RenderPipeline.Snippet POSITION_COLOR_NO_ALPHA_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(LibShaders.POSITION_COLOR_NO_ALPHA_TEST).withFragmentShader(LibShaders.POSITION_COLOR_NO_ALPHA_TEST).withVertexFormat(DefaultVertexFormat.POSITION_COLOR, VertexFormat.Mode.QUADS).buildSnippet();
        RP_POSITION_COLOR_TEX_TRANSLUCENT = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_col_tex_translucent")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withCull(false).build();
        RP_POSITION_COLOR_TEX_TRANSLUCENT_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_col_tex_translucent_cull")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).build();
        RP_POSITION_COLOR_TEX_TRANSLUCENT_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_col_tex_translucent_no_depth")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withCull(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        RP_POSITION_COLOR_TEX_PREMULTIPLIED = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_col_tex_premultiplied")).withBlend(PREMULTIPLIED_TRANSPARENCY).withCull(false).build();
        RP_POSITION_COLOR_TEX_NO_BLEND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_col_tex_no_blend")).withoutBlend().build();
        RP_POSITION_COLOR_TRANSLUCENT = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_col_translucent")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).build();
        RP_POSITION_COLOR_NO_BLEND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_col_no_blend")).withoutBlend().build();
        RP_POSITION_COLOR_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/pos_col_translucent")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withCull(false).build();
        RP_LINES = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/lines")).withVertexShader(LibShaders.FRAMEBUFFER_LINES).withFragmentShader(LibShaders.FRAMEBUFFER_LINES).withUniform(BuiltInCustomUniforms.FRAME_SIZE.name(), BuiltInCustomUniforms.FRAME_SIZE.type()).withVertexFormat(DefaultVertexFormat.POSITION_COLOR_NORMAL_LINE_WIDTH, VertexFormat.Mode.LINES).withBlend(LINES_TRANSPARENCY).build();
        RP_DEPTH_CLEAR = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_NO_ALPHA_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/depth_clear")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withDepthTestFunction(DepthTestFunction.GREATER_DEPTH_TEST).withColorWrite(false, false).build();
        RP_MAP = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/map")).withVertexShader(LibShaders.WORLD_MAP).withFragmentShader(LibShaders.WORLD_MAP).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).withSampler("Sampler0").withUniform(BuiltInCustomUniforms.BRIGHTNESS.name(), BuiltInCustomUniforms.BRIGHTNESS.type()).withUniform(BuiltInCustomUniforms.WITH_LIGHT.name(), BuiltInCustomUniforms.WITH_LIGHT.type()).withBlend(DEST_TRANSPARENCY).withCull(false).build();
        RP_MAP_BRANCH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/map_branch")).withVertexShader(LibShaders.WORLD_MAP_BRANCH).withFragmentShader(LibShaders.WORLD_MAP_BRANCH).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).withSampler("Sampler0").withoutBlend().withCull(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withDepthWrite(false).build();
        RP_MAP_FRAME = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/map_frame")).withBlend(DEST_TRANSPARENCY).withCull(false).withDepthWrite(false).build();
        RP_COLOR_FILLER = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(Identifier.fromNamespaceAndPath((String)"xaerolib", (String)"pipeline/color_filler")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withDepthWrite(false).build();
    }
}

