/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics.shader;

import com.mojang.blaze3d.shaders.Uniform;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.CompiledShaderProgram;
import xaero.lib.client.graphics.shader.LibShaders;

public class WorldMapShaderHelper {
    private static CompiledShaderProgram CACHED_FOR_SHADER_PROGRAM;
    private static Uniform BRIGHTNESS;
    private static Uniform WITH_LIGHT;

    public static void setBrightness(float brightness) {
        WorldMapShaderHelper.ensureUniforms();
        if (BRIGHTNESS.getFloatBuffer().get(0) != brightness) {
            BRIGHTNESS.set(brightness);
        }
    }

    public static void setWithLight(boolean withLight) {
        int withLightInt;
        WorldMapShaderHelper.ensureUniforms();
        int n = withLightInt = withLight ? 1 : 0;
        if (WITH_LIGHT.getIntBuffer().get(0) != withLightInt) {
            WITH_LIGHT.set(withLightInt);
        }
    }

    private static void ensureUniforms() {
        CompiledShaderProgram currentProgram = Minecraft.getInstance().getShaderManager().getProgram(LibShaders.WORLD_MAP);
        if (currentProgram != CACHED_FOR_SHADER_PROGRAM) {
            CACHED_FOR_SHADER_PROGRAM = currentProgram;
            BRIGHTNESS = currentProgram.getUniform("Brightness");
            WITH_LIGHT = currentProgram.getUniform("WithLight");
        }
    }
}

