/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics.util;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;

public class TextureUtils {
    public static void setTexture(int index, ResourceLocation textureLocation) {
        AbstractTexture textureObject = Minecraft.getInstance().getTextureManager().getTexture(textureLocation);
        GpuTextureView texture = textureObject == null ? null : textureObject.getTextureView();
        RenderSystem.setShaderTexture((int)index, (GpuTextureView)texture);
    }

    public static void clearRenderTarget(RenderTarget renderTarget, int color, float depth) {
        RenderSystem.getDevice().createCommandEncoder().clearColorAndDepthTextures(renderTarget.getColorTexture(), color, renderTarget.getDepthTexture(), (double)depth);
    }

    public static void clearRenderTarget(RenderTarget renderTarget, int color) {
        RenderSystem.getDevice().createCommandEncoder().clearColorTexture(renderTarget.getColorTexture(), color);
    }

    public static void clearRenderTargetDepth(RenderTarget renderTarget, float depth) {
        RenderSystem.getDevice().createCommandEncoder().clearDepthTexture(renderTarget.getDepthTexture(), (double)depth);
    }

    public static IntBuffer allocateLittleEndianIntBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity * 4).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
    }
}

