/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet;

import net.minecraft.class_2540;
import net.minecraft.class_4093;
import xaero.lib.common.packet.PacketHandlerFull;
import xaero.lib.common.packet.type.PacketType;

public abstract class PacketReceiver<C> {
    private final PacketHandlerFull packetHandlerFull;

    public PacketReceiver(PacketHandlerFull packetHandlerFull) {
        this.packetHandlerFull = packetHandlerFull;
    }

    private PacketType<?> getPacketType(class_2540 buf) {
        if (buf.readableBytes() <= 0) {
            return null;
        }
        byte index = buf.readByte();
        return this.packetHandlerFull.getPacketTypeByIndex(index);
    }

    protected void receive(class_4093<?> executor, class_2540 buf, C context) {
        this.receive(executor, this.getPacketType(buf), buf, context);
    }

    private <T> void receive(class_4093<?> executor, PacketType<T> packetType, class_2540 buf, C context) {
        if (packetType == null) {
            return;
        }
        if (!this.isCorrectSide(packetType)) {
            return;
        }
        T packet = packetType.getDecoder().apply(buf);
        if (executor.method_18854()) {
            this.getTask(packetType, packet, context).run();
            return;
        }
        executor.execute(this.getTask(packetType, packet, context));
    }

    protected abstract <T> boolean isCorrectSide(PacketType<T> var1);

    protected abstract <T> Runnable getTask(PacketType<T> var1, T var2, C var3);
}

