/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui;

import com.google.common.base.Objects;
import java.util.ArrayList;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import xaero.lib.XaeroLib;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.util.GuiUtils;
import xaero.lib.client.gui.widget.MyTinyButton;
import xaero.lib.client.gui.widget.online.WidgetScreen;
import xaero.lib.common.util.KeySortableByOther;

public abstract class GuiSettings
extends ScreenBase
implements WidgetScreen {
    protected int entriesPerPage = 12;
    protected ISettingEntry[] entries;
    protected String entryFilter = "";
    private boolean foundSomething;
    protected class_2561 screenTitle;
    protected int page;
    protected int maxPage;
    private MyTinyButton nextButton;
    private MyTinyButton prevButton;
    protected class_342 searchField;
    protected boolean canSearch = true;
    private boolean shouldRefocusSearch;
    protected boolean confirmButton;

    public GuiSettings(class_2561 title, class_437 backScreen, class_437 escScreen) {
        this(title, backScreen, escScreen, false);
    }

    public GuiSettings(class_2561 title, class_437 backScreen, class_437 escScreen, boolean confirmButton) {
        super(backScreen, escScreen, title);
        this.confirmButton = confirmButton;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.screenTitle = this.field_22785;
        if (this.confirmButton) {
            this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 105, this.field_22790 / 6 + 168, 100, 20, (class_2561)new class_2588("gui.xaero_confirm"), b -> this.confirm()));
            this.method_25411((class_339)new class_4185(this.field_22789 / 2 + 5, this.field_22790 / 6 + 168, 100, 20, (class_2561)new class_2588("gui.xaero_back"), b -> this.goBack()));
        } else {
            this.method_25411((class_339)new class_4185(this.field_22789 / 2 - 100, this.field_22790 / 6 + 168, 200, 20, (class_2561)new class_2588("gui.xaero_back", new Object[0]), b -> this.goBack()));
        }
        int verticalOffset = this.getVerticalOffset();
        if (this.entries != null) {
            ArrayList<KeySortableByOther<ISettingEntry>> sortingList = new ArrayList<KeySortableByOther<ISettingEntry>>();
            String comparisonFilter = this.entryFilter.toLowerCase();
            for (int i = 0; i < this.entries.length; ++i) {
                int positionInEntryString;
                ISettingEntry entry = this.entries[i];
                String entrySearchString = entry.getStringForSearch().toLowerCase();
                if (entrySearchString == null || (positionInEntryString = entrySearchString.indexOf(comparisonFilter)) == -1) continue;
                KeySortableByOther<ISettingEntry> sortableEntry = new KeySortableByOther<ISettingEntry>(entry, Integer.valueOf(positionInEntryString));
                sortingList.add(sortableEntry);
            }
            ArrayList filteredEntries = sortingList.stream().sorted().map(KeySortableByOther::getKey).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            if (!filteredEntries.isEmpty()) {
                this.foundSomething = true;
                this.maxPage = (int)Math.ceil((double)filteredEntries.size() / (double)this.entriesPerPage) - 1;
                if (this.page > this.maxPage) {
                    this.page = this.maxPage;
                }
                int firstEntry = this.entriesPerPage * this.page;
                int entryCount = Math.min(filteredEntries.size() - firstEntry, this.entriesPerPage);
                for (int i = 0; i < entryCount; ++i) {
                    ISettingEntry entry = (ISettingEntry)filteredEntries.get(firstEntry + i);
                    class_339 optionWidget = entry.createWidget(this.field_22789 / 2 - 205 + i % 2 * 210, this.field_22790 / 7 + 5 + verticalOffset + 24 * (i >> 1), 200);
                    this.method_25411(optionWidget);
                }
            } else {
                this.foundSomething = false;
                this.page = 0;
                this.maxPage = 0;
            }
        }
        this.screenTitle = this.screenTitle.method_27662().method_27693(" (" + (this.page + 1) + "/" + (this.maxPage + 1) + ")");
        this.nextButton = new MyTinyButton(this.field_22789 / 2 + 131, this.field_22790 / 7 + 149 + verticalOffset, (class_2561)new class_2588("gui.xaero_next", new Object[0]), b -> this.onNextButton());
        this.prevButton = new MyTinyButton(this.field_22789 / 2 - 205, this.field_22790 / 7 + 149 + verticalOffset, (class_2561)new class_2588("gui.xaero_previous", new Object[0]), b -> this.onPrevButton());
        if (this.maxPage > 0) {
            this.method_25411((class_339)this.nextButton);
            this.method_25411((class_339)this.prevButton);
            this.nextButton.field_22763 = this.page < this.maxPage;
            this.prevButton.field_22763 = this.page > 0;
        }
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().initialize(this, this.field_22789, this.field_22790);
        boolean shouldFocusSearch = this.shouldRefocusSearch;
        this.shouldRefocusSearch = false;
        if (this.canSearch && this.entries != null) {
            int cursorPos = 0;
            if (shouldFocusSearch) {
                cursorPos = this.searchField.method_1881();
            }
            this.searchField = new class_342(this.field_22793, this.field_22789 / 2 - 100, this.field_22790 / 7 + 5 + verticalOffset - 24, 200, 20, (class_2561)new class_2588("gui.xaero_settings_search"));
            this.searchField.method_1852(this.entryFilter);
            if (shouldFocusSearch) {
                this.method_25395((class_364)this.searchField);
                this.searchField.method_1876(true);
                this.searchField.method_1875(cursorPos);
                this.searchField.method_1884(cursorPos);
            }
            this.searchField.method_1863(s -> {
                if (this.canSearch) {
                    this.updateSearch();
                }
            });
            this.field_22786.add(this.searchField);
        } else {
            this.searchField = null;
        }
        this.field_22787.field_1774.method_1462(true);
    }

    protected void confirm() {
        this.onExit(this.escape);
    }

    protected int getVerticalOffset() {
        return this.canSearch ? 24 : 0;
    }

    public void method_25393() {
        super.method_25393();
        if (this.canSearch && this.searchField != null) {
            this.searchField.method_1865();
        }
    }

    @Override
    protected void renderPreDropdown(class_4587 matrixStack, int mouseX, int mouseY, float partial) {
        super.renderPreDropdown(matrixStack, mouseX, mouseY, partial);
        if (this.searchField != null) {
            if (!this.foundSomething && this.entries != null) {
                GuiSettings.method_25300((class_4587)matrixStack, (class_327)this.field_22787.field_1772, (String)class_1074.method_4662((String)"gui.xaero_settings_not_found", (Object[])new Object[0]), (int)(this.field_22789 / 2), (int)(this.field_22790 / 7 + 34), (int)0xFFFFFF);
            }
            if (!this.searchField.method_25370() && this.searchField.method_1882().isEmpty()) {
                GuiUtils.setFieldText(this.searchField, class_1074.method_4662((String)"gui.xaero_settings_search_placeholder", (Object[])new Object[0]), -11184811);
                this.searchField.method_1883(0);
            }
            this.searchField.method_25394(matrixStack, mouseX, mouseY, partial);
            if (!this.searchField.method_25370()) {
                GuiUtils.setFieldText(this.searchField, this.entryFilter);
            }
        }
    }

    @Override
    public void method_25394(class_4587 matrixStack, int par1, int par2, float par3) {
        this.method_25420(matrixStack);
        int verticalOffset = this.getVerticalOffset();
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().render(matrixStack, this, this.field_22789, this.field_22790, par1, par2, this.field_22787.method_22683().method_4495());
        GuiSettings.method_27534((class_4587)matrixStack, (class_327)this.field_22787.field_1772, (class_2561)this.screenTitle, (int)(this.field_22789 / 2), (int)(this.field_22790 / 7 + 29 - 42), (int)0xFFFFFF);
        super.method_25394(matrixStack, par1, par2, par3);
        if (this.openDropdown == null) {
            this.renderTooltips(matrixStack, par1, par2, par3);
        }
    }

    @Override
    public void addButtonVisible(class_339 button) {
        this.method_25411(button);
    }

    @Override
    public <S extends class_437> S getScreen() {
        return (S)this;
    }

    @Override
    public void onExit(class_437 screen) {
        super.onExit(screen);
    }

    public boolean method_25404(int par1, int par2, int par3) {
        return super.method_25404(par1, par2, par3) || this.method_25399() instanceof class_342 && ((class_342)this.method_25399()).method_25370();
    }

    public boolean method_25400(char c, int i) {
        boolean result = super.method_25400(c, i);
        return result;
    }

    @Override
    public boolean method_25402(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().handleClick(this, this.field_22789, this.field_22790, (int)p_mouseClicked_1_, (int)p_mouseClicked_3_, this.field_22787.method_22683().method_4495());
        return super.method_25402(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    protected void onNextButton() {
        ++this.page;
        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
    }

    protected void onPrevButton() {
        --this.page;
        this.method_25423(this.field_22787, this.field_22789, this.field_22790);
    }

    public ISettingEntry[] getEntriesCopy() {
        if (this.entries == null) {
            return null;
        }
        ISettingEntry[] result = new ISettingEntry[this.entries.length];
        System.arraycopy(this.entries, 0, result, 0, this.entries.length);
        return result;
    }

    public void method_25395(class_364 guiEventListener) {
        class_364 currentFocused = this.method_25399();
        if (currentFocused != guiEventListener && currentFocused instanceof class_342) {
            ((class_342)currentFocused).method_1876(false);
        }
        super.method_25395(guiEventListener);
    }

    private void updateSearch() {
        String newValue;
        if (this.searchField.method_25370() && !Objects.equal((Object)this.entryFilter, (Object)(newValue = this.searchField.method_1882()))) {
            this.entryFilter = this.searchField.method_1882();
            this.shouldRefocusSearch = true;
            this.page = 0;
            this.method_25423(this.field_22787, this.field_22789, this.field_22790);
        }
    }
}

