/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.config.option.ui.factory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5676;
import xaero.lib.client.config.option.ui.factory.IConfigOptionWidgetFactory;
import xaero.lib.client.config.option.ui.factory.ICustomOptionEditScreenFactory;
import xaero.lib.client.config.option.ui.factory.ViewEnforcedCondition;
import xaero.lib.client.config.option.value.redirect.ClientOptionValueRedirectorManager;
import xaero.lib.client.gui.IScreenBase;
import xaero.lib.client.gui.config.EditConfigScreen;
import xaero.lib.client.gui.config.EditStringConfigOptionScreen;
import xaero.lib.client.gui.widget.CycleButtonOption;
import xaero.lib.client.gui.widget.IClickableWidget;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.XaeroSliderWidget;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.channel.ConfigChannel;
import xaero.lib.common.config.option.BuiltInProfiledConfigOptions;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.option.IndexedConfigOption;
import xaero.lib.common.config.util.ConfigUtils;

public class StandardConfigWidgetFactories {
    public static <T, CT extends IndexedConfigOption<T>> IConfigOptionWidgetFactory<CT> getIndexedCycleButtonFactory() {
        return (option, config, enforced, x, y, w, includeNullValue, onChange, channel, clientSide) -> StandardConfigWidgetFactories.createCycleButton(option, config, enforced, x, y, w, includeNullValue, option.getValidValues(), onChange, channel, clientSide);
    }

    public static <T, CT extends IndexedConfigOption<T>> IConfigOptionWidgetFactory<CT> getIndexedSliderFactory() {
        return (option, config, enforced, x, y, w, includeNullValue, onChange, channel, clientSide) -> StandardConfigWidgetFactories.createSliderWithValues(option, config, enforced, x, y, w, includeNullValue, option.getValidValues(), onChange, channel, clientSide);
    }

    public static <CT extends ConfigOption<?>> IConfigOptionWidgetFactory<CT> getStringEditFactory() {
        return StandardConfigWidgetFactories::createStringEditButton;
    }

    public static <CT extends ConfigOption<?>> IConfigOptionWidgetFactory<CT> getOpenScreenFactory(ICustomOptionEditScreenFactory<CT> screenFactory, ViewEnforcedCondition viewEnforcedCondition) {
        return (option, config, enforced, x, y, w, includeNullValue, onChange, channel, clientSide) -> StandardConfigWidgetFactories.createOpenScreenButton(option, config, enforced, x, y, w, includeNullValue, onChange, channel, clientSide, screenFactory, viewEnforcedCondition);
    }

    private static <T, CT extends ConfigOption<T>> class_339 createCycleButton(CT option, Config config, Config enforced, int x, int y, int w, boolean includeNullValue, List<T> values, Runnable onChange, ConfigChannel channel, boolean clientSide) {
        ArrayList<CycleButtonOption<Object>> allValues = new ArrayList<CycleButtonOption<Object>>();
        if (includeNullValue) {
            allValues.add(new CycleButtonOption<Object>(null));
        }
        values.stream().map(CycleButtonOption::new).forEach(allValues::add);
        ClientOptionValueRedirectorManager redirectorManager = clientSide ? channel.getClientConfigManager().getRedirectorManager() : null;
        class_5676 resultButton = class_5676.method_32606(v -> ConfigUtils.getEffectiveValueName(redirectorManager, option, config, enforced)).method_32620(allValues).method_32619(new CycleButtonOption(config.get(option))).method_32617(x, y, w, 20, option.getDisplayName(), (button, value) -> {
            if (clientSide && redirectorManager.redirectScreen(option)) {
                return;
            }
            config.set(option, value.get());
            button.method_32605(value);
            onChange.run();
        });
        if (clientSide && redirectorManager.shouldDeactivateWidget(option)) {
            resultButton.field_22763 = false;
        }
        StandardConfigWidgetFactories.addTooltipToWidget((class_339)resultButton, option, enforced, redirectorManager, null);
        return resultButton;
    }

    private static <T, CT extends ConfigOption<T>> class_339 createSliderWithValues(CT option, Config config, Config enforced, int x, int y, int w, boolean includeNullValue, List<T> values, Runnable onChange, ConfigChannel channel, boolean clientSide) {
        double sliderValue;
        ClientOptionValueRedirectorManager redirectorManager;
        List allValues = values;
        if (includeNullValue) {
            allValues = new ArrayList<T>();
            allValues.add(null);
            allValues.addAll(values);
        }
        List finalValues = allValues;
        Object currentValue = config.get(option);
        ClientOptionValueRedirectorManager clientOptionValueRedirectorManager = redirectorManager = clientSide ? channel.getClientConfigManager().getRedirectorManager() : null;
        if (finalValues.size() == 1 || clientSide && redirectorManager.shouldRedirect(option)) {
            sliderValue = 1.0;
        } else {
            sliderValue = (double)allValues.indexOf(currentValue) / (double)(finalValues.size() - 1);
            sliderValue = class_3532.method_15350((double)sliderValue, (double)0.0, (double)1.0);
        }
        XaeroSliderWidget resultSlider = new XaeroSliderWidget(x, y, w, 20, StandardConfigWidgetFactories.getSliderLabel(option, config, enforced, channel, clientSide), sliderValue, newSliderValue -> {
            if (clientSide && redirectorManager.redirectScreen(option)) {
                return;
            }
            int newIndex = (int)Math.round(newSliderValue * (double)(finalValues.size() - 1));
            Object newValue = finalValues.get(newIndex);
            if (newValue != config.get(option)) {
                config.set(option, newValue);
                if (class_310.method_1551().field_1755 instanceof EditConfigScreen) {
                    ((EditConfigScreen)class_310.method_1551().field_1755).handleChangesOnExit();
                }
            }
        }, () -> StandardConfigWidgetFactories.getSliderLabel(option, config, enforced, channel, clientSide));
        if (clientSide && redirectorManager.shouldDeactivateWidget(option)) {
            resultSlider.field_22763 = false;
        }
        StandardConfigWidgetFactories.addTooltipToWidget((class_339)resultSlider, option, enforced, redirectorManager, null);
        return resultSlider;
    }

    private static <T> class_2561 getSliderLabel(ConfigOption<T> option, Config config, Config enforced, ConfigChannel channel, boolean clientSide) {
        ClientOptionValueRedirectorManager redirectorManager = clientSide ? channel.getClientConfigManager().getRedirectorManager() : null;
        return class_5244.method_32700((class_2561)option.getDisplayName(), (class_2561)ConfigUtils.getEffectiveValueName(redirectorManager, option, config, enforced));
    }

    private static class_339 createStringEditButton(ConfigOption<?> option, Config config, Config enforced, int x, int y, int w, boolean includeNullValue, Runnable onChange, ConfigChannel channel, boolean clientSide) {
        return StandardConfigWidgetFactories.createOpenScreenButton(option, config, enforced, x, y, w, includeNullValue, onChange, channel, clientSide, (parent, escape, config1, enforced1, option1, onChange1, readOnly, includeNullValue1) -> new EditStringConfigOptionScreen(parent, escape, config1, enforced1, option1, includeNullValue1, includeNullValue1, onChange1), null);
    }

    private static <CT extends ConfigOption<?>> class_339 createOpenScreenButton(CT option, Config config, Config enforced, int x, int y, int w, boolean includeNullValue, Runnable onChange, ConfigChannel channel, boolean clientSide, ICustomOptionEditScreenFactory<CT> screenFactory, ViewEnforcedCondition viewEnforcedCondition) {
        ClientOptionValueRedirectorManager redirectorManager = clientSide ? channel.getClientConfigManager().getRedirectorManager() : null;
        class_2561 displayName = option.getDisplayName();
        boolean needsEnforcedIndicator = StandardConfigWidgetFactories.widgetNeedsEnforcedTooltipPrefix(option, enforced);
        if (needsEnforcedIndicator) {
            displayName = new class_2588("gui.xaero_config_value_enforced", new Object[]{displayName.method_27661().method_27692(class_124.field_1068), new class_2588("gui.xaero_config_value_enforced_indicator").method_27692(class_124.field_1054)}).method_27692(class_124.field_1054);
        }
        class_4185 resultButton = new class_4185(x, y, w, 20, displayName, b -> {
            if (clientSide && redirectorManager.redirectScreen(option)) {
                return;
            }
            class_437 parent = class_310.method_1551().field_1755;
            if (!(parent instanceof EditConfigScreen)) {
                return;
            }
            class_437 escape = null;
            if (parent instanceof IScreenBase) {
                escape = ((IScreenBase)parent).getEscape();
            }
            boolean readOnly = needsEnforcedIndicator && viewEnforcedCondition != null && viewEnforcedCondition.getCondition().getAsBoolean();
            Config screenConfig = readOnly ? enforced : config;
            class_310.method_1551().method_1507(screenFactory.get((EditConfigScreen)parent, escape, screenConfig, enforced, option, onChange, readOnly, includeNullValue));
        });
        if (clientSide && redirectorManager.shouldDeactivateWidget(option)) {
            resultButton.field_22763 = false;
        }
        StandardConfigWidgetFactories.addTooltipToWidget((class_339)resultButton, option, enforced, redirectorManager, viewEnforcedCondition);
        return resultButton;
    }

    private static <CT extends ConfigOption<?>> void addTooltipToWidget(class_339 widget, CT option, Config enforced, ClientOptionValueRedirectorManager redirectorManager, ViewEnforcedCondition viewEnforcedCondition) {
        if (!(widget instanceof IClickableWidget)) {
            return;
        }
        if (redirectorManager != null && redirectorManager.shouldRedirect(option)) {
            ((IClickableWidget)widget).setXaero_tooltip(new Tooltip(redirectorManager.getTooltip(option)));
            return;
        }
        Object tooltipComponent = null;
        if (StandardConfigWidgetFactories.widgetNeedsEnforcedTooltipPrefix(option, enforced)) {
            tooltipComponent = viewEnforcedCondition != null ? viewEnforcedCondition.getTooltip().method_27661() : new class_2588("gui.xaero_config_value_enforced_tooltip_prefix");
            tooltipComponent = tooltipComponent.method_27692(class_124.field_1054);
        }
        if (option.getTooltip() != null) {
            class_5250 mainTooltip = option.getTooltip().method_27661().method_27692(class_124.field_1068);
            if (tooltipComponent == null) {
                tooltipComponent = mainTooltip.method_27661();
            } else {
                tooltipComponent.method_10855().add(new class_2585(" \n \n "));
                tooltipComponent.method_10855().add(mainTooltip);
            }
        }
        if (tooltipComponent == null) {
            return;
        }
        ((IClickableWidget)widget).setXaero_tooltip(new Tooltip((class_2561)tooltipComponent));
    }

    public static boolean widgetNeedsEnforcedTooltipPrefix(ConfigOption<?> option, Config enforced) {
        return enforced != null && option != BuiltInProfiledConfigOptions.PROFILE_NAME && enforced.get(option) != null;
    }
}

