/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config.profile;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import xaero.lib.XaeroLib;
import xaero.lib.common.packet.config.AbstractConfigPacket;
import xaero.lib.common.player.ServerPlayerData;
import xaero.lib.platform.Services;

public final class ConfigProfileEditPacket
extends AbstractConfigPacket<ConfigProfileEditPacket> {
    private final String profileId;

    public ConfigProfileEditPacket(String profileId, List<AbstractConfigPacket.OptionEntry> entries) {
        super(entries);
        this.profileId = profileId;
    }

    @Override
    protected void writeExtra(class_2487 tag) {
        tag.method_10582("i", this.profileId);
    }

    public static ConfigProfileEditPacket read(class_2540 buffer) {
        try {
            class_2487 tag = buffer.method_30616(new class_2505(0x800000L));
            if (tag == null) {
                return null;
            }
            List<AbstractConfigPacket.OptionEntry> entries = ConfigProfileEditPacket.readOptions(tag);
            String profileId = tag.method_10558("i");
            return new ConfigProfileEditPacket(profileId, entries);
        }
        catch (Throwable t) {
            if (Services.PLATFORM.isDevelopmentEnvironment() || !Services.PLATFORM.isDedicatedServer()) {
                XaeroLib.LOGGER.error("packet error", t);
            }
            return null;
        }
    }

    public static final class ServerHandler
    implements BiConsumer<ConfigProfileEditPacket, class_3222> {
        @Override
        public void accept(ConfigProfileEditPacket message, class_3222 player) {
            block2: {
                try {
                    ServerPlayerData.get(player).getConfigSynchronizer().onEditProfilePacket(message.profileId, message.getEntries());
                }
                catch (Throwable t) {
                    if (!Services.PLATFORM.isDevelopmentEnvironment()) break block2;
                    XaeroLib.LOGGER.error("packet error", t);
                }
            }
        }
    }

    public static final class ClientHandler
    implements Consumer<ConfigProfileEditPacket> {
        @Override
        public void accept(ConfigProfileEditPacket message) {
            try {
                XaeroLib.INSTANCE.getClient().getConfigSynchronizer().onEditProfilePacket(message.profileId, message.getEntries());
            }
            catch (Throwable t) {
                XaeroLib.LOGGER.error("packet error", t);
            }
        }
    }
}

