/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_339;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.widget.CycleButtonOption;
import xaero.lib.client.gui.widget.IClickableWidget;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.XaeroSliderWidget;
import xaero.lib.common.config.util.ConfigConstants;
import xaero.lib.common.gui.widget.TooltipInfo;

public class CustomSettingEntry<T>
implements ISettingEntry {
    private final BooleanSupplier allowNull;
    private final class_2561 name;
    private final TooltipInfo tooltipInfo;
    private final boolean slider;
    private Supplier<T> currentValueSupplier;
    private final int minIndex;
    private final int maxIndex;
    private final IntFunction<T> indexReader;
    private final Function<T, class_2561> valueNamer;
    private final BiConsumer<T, T> onValueChange;
    private final BooleanSupplier activeSupplier;

    public CustomSettingEntry(BooleanSupplier allowNull, class_2561 name, TooltipInfo tooltipInfo, boolean slider, Supplier<T> currentValueSupplier, int minIndex, int maxIndex, IntFunction<T> indexReader, Function<T, class_2561> valueNamer, BiConsumer<T, T> onValueChange, BooleanSupplier activeSupplier) {
        this.allowNull = allowNull;
        this.name = name;
        this.tooltipInfo = tooltipInfo;
        this.slider = slider;
        this.currentValueSupplier = currentValueSupplier;
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
        this.indexReader = indexReader;
        this.valueNamer = valueNamer;
        this.onValueChange = onValueChange;
        this.activeSupplier = activeSupplier;
    }

    @Override
    public String getStringForSearch() {
        class_2561 displayName = this.name;
        T currentValue = this.currentValueSupplier.get();
        Object result = class_5244.method_32700((class_2561)displayName, (class_2561)(currentValue == null ? ConfigConstants.UNSPECIFIED : this.valueNamer.apply(currentValue))).getString();
        if (displayName instanceof class_2588) {
            result = (String)result + " " + ((class_2588)displayName).method_11022().replace("gui.xaero", "");
        }
        if (this.tooltipInfo != null) {
            result = (String)result + " " + this.tooltipInfo.text.getString();
            if (this.tooltipInfo.text instanceof class_2588) {
                result = (String)result + " " + ((class_2588)this.tooltipInfo.text).method_11022().replace("gui.xaero", "");
            }
        }
        return result;
    }

    @Override
    public class_339 createWidget(int x, int y, int w) {
        Object result;
        ArrayList<CycleButtonOption<T>> values = new ArrayList<CycleButtonOption<T>>();
        CycleButtonOption<T> initialOption = null;
        int initialOptionIndex = -1;
        if (this.allowNull.getAsBoolean()) {
            values.add(new CycleButtonOption<Object>(null));
        }
        T currentValue = this.currentValueSupplier.get();
        for (int i = this.minIndex; i <= this.maxIndex; ++i) {
            T value = this.indexReader.apply(i);
            CycleButtonOption<T> option = new CycleButtonOption<T>(value);
            values.add(option);
            if (!Objects.equals(value, currentValue)) continue;
            initialOption = option;
            initialOptionIndex = values.size() - 1;
        }
        if (initialOption == null) {
            initialOption = (CycleButtonOption<T>)values.get(0);
            initialOptionIndex = 0;
        }
        class_2561 displayName = this.name;
        if (!this.slider) {
            result = class_5676.method_32606(co -> this.getValueName(co.get())).method_32620(values).method_32619((Object)initialOption).method_32617(x, y, w, 20, displayName, (b, o) -> {
                T oldValue = this.currentValueSupplier.get();
                if (this.onValueChange != null) {
                    this.onValueChange.accept(oldValue, o.get());
                }
            });
        } else {
            Supplier<class_2561> labelGetter = () -> class_5244.method_32700((class_2561)displayName, (class_2561)this.getValueName(this.currentValueSupplier.get()));
            double initialSliderValue = (double)initialOptionIndex / (double)(values.size() - 1);
            result = new XaeroSliderWidget(x, y, w, 20, labelGetter.get(), initialSliderValue, newSliderValue -> {
                int selectedOptionIndex = (int)Math.round(newSliderValue * (double)(values.size() - 1));
                CycleButtonOption selectedOption = (CycleButtonOption)values.get(selectedOptionIndex);
                T oldValue = this.currentValueSupplier.get();
                if (this.onValueChange != null) {
                    this.onValueChange.accept(oldValue, selectedOption.get());
                }
            }, labelGetter);
        }
        result.field_22763 = this.activeSupplier.getAsBoolean();
        if (this.tooltipInfo != null) {
            ((IClickableWidget)result).setXaero_tooltip(new Tooltip(this.tooltipInfo));
        }
        return result;
    }

    public class_2561 getValueName(T value) {
        if (value == null) {
            return ConfigConstants.UNSPECIFIED;
        }
        return this.valueNamer.apply(value);
    }
}

