/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.compat.luckperms;

import java.util.SortedSet;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.MetaNode;
import net.luckperms.api.query.QueryOptions;
import net.minecraft.class_3222;
import xaero.lib.common.permission.PermissionNode;
import xaero.lib.common.permission.system.IPermissionSystem;
import xaero.lib.common.permission.util.PermissionUtils;

public class LuckPermsSystem
implements IPermissionSystem {
    private User getUser(class_3222 player) {
        return LuckPermsProvider.get().getPlayerAdapter(class_3222.class).getUser((Object)player);
    }

    @Override
    public boolean getBoolean(PermissionNode<Boolean> node, class_3222 player) {
        User user = this.getUser(player);
        SortedSet nodes = user.resolveDistinctInheritedNodes(QueryOptions.defaultContextualOptions());
        String actualNodePath = node.getActualPath();
        for (Node nodeObject : nodes) {
            if (!nodeObject.getKey().equals(actualNodePath)) continue;
            return nodeObject.getValue();
        }
        return false;
    }

    @Override
    public boolean getBooleanFast(PermissionNode<Boolean> node, class_3222 player) {
        User user = this.getUser(player);
        return user.getCachedData().getPermissionData().checkPermission(node.getActualPath()).asBoolean();
    }

    @Override
    public <T> T get(PermissionNode<T> node, class_3222 player) {
        User user = this.getUser(player);
        SortedSet nodes = user.resolveDistinctInheritedNodes(QueryOptions.defaultContextualOptions());
        String actualNodePath = node.getActualPath();
        for (Node nodeObject : nodes) {
            if (nodeObject.getType() != NodeType.META || !nodeObject.getKey().equals(actualNodePath)) continue;
            MetaNode metaNode = (MetaNode)nodeObject;
            String valueString = metaNode.getMetaValue();
            if (valueString == null) {
                return null;
            }
            return PermissionUtils.parseString(node, valueString);
        }
        return null;
    }

    @Override
    public <T> T getFast(PermissionNode<T> node, class_3222 player) {
        User user = this.getUser(player);
        String valueString = user.getCachedData().getMetaData().getMetaValue(node.getActualPath());
        if (valueString == null) {
            return null;
        }
        return PermissionUtils.parseString(node, valueString);
    }

    @Override
    public void handleModPresence(String modId) {
    }
}

