/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.option.value.sync.serialization.ConfigValueSyncCodec;

public abstract class AbstractConfigPacket<P extends AbstractConfigPacket<P>> {
    private final List<OptionEntry> entries;

    protected AbstractConfigPacket(List<OptionEntry> entries) {
        this.entries = entries;
    }

    public void write(class_2540 buffer) {
        class_2487 tag = new class_2487();
        class_2487 optionsTag = new class_2487();
        for (OptionEntry entry : this.entries) {
            optionsTag.method_10566(entry.optionId, entry.valueTag);
        }
        tag.method_10566("o", (class_2520)optionsTag);
        this.writeExtra(tag);
        buffer.method_10794((class_2520)tag);
    }

    public Iterable<OptionEntry> getEntries() {
        return this.entries;
    }

    protected abstract void writeExtra(class_2487 var1);

    public static List<OptionEntry> readOptions(class_2487 tag) {
        class_2487 optionsTag = tag.method_10562("o");
        ArrayList<OptionEntry> result = new ArrayList<OptionEntry>();
        for (String optionId : optionsTag.method_10541()) {
            class_2520 valueTag = optionsTag.method_10580(optionId);
            result.add(new OptionEntry(optionId, valueTag));
        }
        return result;
    }

    public static class OptionEntry {
        public static final class_2520 NULL_VALUE = new class_2487();
        public final String optionId;
        public final class_2520 valueTag;

        public OptionEntry(String optionId, class_2520 valueTag) {
            this.optionId = optionId;
            this.valueTag = valueTag == null ? NULL_VALUE : valueTag;
        }

        public static <T> OptionEntry of(ConfigOption<T> option, T value) {
            ConfigValueSyncCodec<T, class_2520> syncCodec = option.getValueType().getSyncCodec();
            class_2520 valueTag = value == null ? null : syncCodec.encode(value);
            return new OptionEntry(option.getId(), valueTag);
        }

        public static <T> OptionEntry of(Config config, ConfigOption<T> option) {
            return OptionEntry.of(option, config.get(option));
        }
    }
}

