/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet;

import io.netty.buffer.Unpooled;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import xaero.lib.common.packet.IPacketHandler;
import xaero.lib.common.packet.payload.PacketPayload;
import xaero.lib.common.packet.type.PacketType;
import xaero.lib.common.packet.type.PacketTypeManager;

public abstract class PacketHandlerFull
implements IPacketHandler {
    protected final class_2960 channelId;
    protected final PacketTypeManager packetTypeManager;
    protected final class_8710.class_9154<PacketPayload<?>> type;

    protected PacketHandlerFull(class_2960 channelId, PacketTypeManager packetTypeManager, class_8710.class_9154<PacketPayload<?>> type) {
        this.channelId = channelId;
        this.packetTypeManager = packetTypeManager;
        this.type = type;
    }

    @Override
    public <P> void register(int index, Class<P> type, BiConsumer<P, class_2540> encoder, Function<class_2540, P> decoder, BiConsumer<P, class_3222> serverHandler, Consumer<P> clientHandler) {
        this.packetTypeManager.register(index, type, encoder, decoder, serverHandler, clientHandler);
    }

    public static <T> void encodePacket(PacketType<T> packetType, T packet, class_2540 buffer) {
        if (packetType == null) {
            throw new IllegalArgumentException("unregistered packet class!");
        }
        buffer.method_52997(packetType.getIndex());
        packetType.getEncoder().accept(packet, buffer);
    }

    <T> class_2540 getPacketBuffer(T packet) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        PacketHandlerFull.encodePacket(this.packetTypeManager.getType(packet), packet, buffer);
        return buffer;
    }

    public PacketType<?> getPacketTypeByIndex(int index) {
        return this.packetTypeManager.getByIndex(index);
    }

    public PacketType<?> getByIndex(int index) {
        return this.packetTypeManager.getByIndex(index);
    }

    public <T> PacketPayload<T> createPayload(T packet) {
        return new PacketPayload<T>(this.packetTypeManager.getType(packet), packet, this.type);
    }

    @Override
    public class_2960 getChannelId() {
        return this.channelId;
    }

    public class_8710.class_9154<PacketPayload<?>> getType() {
        return this.type;
    }

    public static abstract class Builder<B extends Builder<B>> {
        private final B self = this;
        protected class_2960 channelId;

        protected Builder() {
        }

        public B setDefault() {
            this.setChannelId(null);
            return this.self;
        }

        public B setChannelId(class_2960 channelId) {
            this.channelId = channelId;
            return this.self;
        }

        public PacketHandlerFull build() {
            if (this.channelId == null) {
                throw new IllegalStateException();
            }
            PacketTypeManager packetTypeManager = PacketTypeManager.Builder.begin().build();
            class_8710.class_9154 type = new class_8710.class_9154(this.channelId);
            return this.buildInternal(packetTypeManager, type);
        }

        protected abstract PacketHandlerFull buildInternal(PacketTypeManager var1, class_8710.class_9154<PacketPayload<?>> var2);
    }
}

