/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics.util;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.minecraft.class_10799;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import xaero.lib.client.graphics.XaeroRenderType;
import xaero.lib.client.graphics.shader.CustomUniforms;
import xaero.lib.client.graphics.shader.PositionTexAlphaTestShaderHelper;
import xaero.lib.platform.Services;

public class ImmediateRenderUtil {
    public static void coloredRectangle(class_4587 matrices, float x1, float y1, float x2, float y2, int color) {
        ImmediateRenderUtil.coloredRectangle(matrices.method_23760().method_23761(), x1, y1, x2, y2, color);
    }

    public static void coloredRectangle(Matrix4f matrix, float x1, float y1, float x2, float y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_60827(VertexFormat.class_5596.field_27382, class_290.field_1576);
        vertexBuffer.method_22918(matrix, x1, y2, 0.0f).method_22915(r, g, b, a);
        vertexBuffer.method_22918(matrix, x2, y2, 0.0f).method_22915(r, g, b, a);
        vertexBuffer.method_22918(matrix, x2, y1, 0.0f).method_22915(r, g, b, a);
        vertexBuffer.method_22918(matrix, x1, y1, 0.0f).method_22915(r, g, b, a);
        ImmediateRenderUtil.drawImmediateMeshData(vertexBuffer.method_60794(), class_10799.field_56879);
    }

    public static void negativeColorRectangle(class_4587 matrices, float x1, float y1, float x2, float y2) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_60827(VertexFormat.class_5596.field_27382, class_290.field_1592);
        vertexBuffer.method_22918(matrix, x1, y2, 0.0f);
        vertexBuffer.method_22918(matrix, x2, y2, 0.0f);
        vertexBuffer.method_22918(matrix, x2, y1, 0.0f);
        vertexBuffer.method_22918(matrix, x1, y1, 0.0f);
        ImmediateRenderUtil.drawImmediateMeshData(vertexBuffer.method_60794(), XaeroRenderType.RP_NEGATIVE_COLOR);
    }

    public static void texturedRect(class_4587 matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        ImmediateRenderUtil.texturedRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, 0.0f);
    }

    public static void texturedRect(class_4587 matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha) {
        RenderPipeline pipeline;
        if (discardAlpha < 0.0f) {
            pipeline = XaeroRenderType.RP_POSITION_TEX_NO_ALPHA;
        } else {
            pipeline = XaeroRenderType.RP_POSITION_TEX_ALPHA;
            PositionTexAlphaTestShaderHelper.setDiscardAlpha(discardAlpha);
        }
        ImmediateRenderUtil.texturedRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, pipeline);
    }

    public static void texturedRect(class_4587 matrixStack, float x, float y, int textureX, int textureY, float width, float height, float textureH, float factor, RenderPipeline renderPipeline) {
        float f;
        float f1 = f = 1.0f / factor;
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_60827(VertexFormat.class_5596.field_27382, renderPipeline.getVertexFormat());
        vertexBuffer.method_22918(matrix, x + 0.0f, y + height, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913((float)(textureX + 0) * f, (float)(textureY + 0) * f1);
        vertexBuffer.method_22918(matrix, x + width, y + height, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(((float)textureX + width) * f, (float)(textureY + 0) * f1);
        vertexBuffer.method_22918(matrix, x + width, y + 0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913(((float)textureX + width) * f, ((float)textureY + textureH) * f1);
        vertexBuffer.method_22918(matrix, x + 0.0f, y + 0.0f, 0.0f).method_22915(1.0f, 1.0f, 1.0f, 1.0f).method_22913((float)(textureX + 0) * f, ((float)textureY + textureH) * f1);
        ImmediateRenderUtil.drawImmediateMeshData(vertexBuffer.method_60794(), renderPipeline);
    }

    public static void drawOutlineLayer(class_4587 matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha) {
        RenderPipeline pipeline = XaeroRenderType.RP_ICON_OUTLINE;
        PositionTexAlphaTestShaderHelper.setDiscardAlpha(discardAlpha);
        ImmediateRenderUtil.texturedRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, pipeline);
    }

    public static void drawImmediateMeshData(class_9801 meshData, RenderPipeline renderPipeline) {
        ImmediateRenderUtil.drawImmediateMeshData(meshData, renderPipeline, class_310.method_1551().method_1522());
    }

    public static void drawImmediateMeshData(class_9801 meshData, RenderPipeline renderPipeline, class_276 target) {
        VertexFormat.class_5595 gpuIndexType;
        GpuBuffer gpuIndexBuffer;
        ByteBuffer indexBuffer = meshData.method_60821();
        if (indexBuffer == null) {
            RenderSystem.class_5590 sequentialBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)meshData.method_60822().comp_752());
            gpuIndexBuffer = sequentialBuffer.method_68274(meshData.method_60822().comp_751());
            gpuIndexType = sequentialBuffer.method_31924();
        } else {
            gpuIndexBuffer = renderPipeline.getVertexFormat().uploadImmediateIndexBuffer(indexBuffer);
            gpuIndexType = meshData.method_60822().comp_753();
        }
        GpuBuffer gpuVertexBuffer = renderPipeline.getVertexFormat().uploadImmediateVertexBuffer(meshData.method_60818());
        try (class_9801 class_98012 = meshData;
             RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(target.method_30277(), OptionalInt.empty(), target.field_1478 ? target.method_30278() : null, OptionalDouble.empty());){
            ImmediateRenderUtil.prepareRenderPass(renderPass, renderPipeline);
            renderPass.setIndexBuffer(gpuIndexBuffer, gpuIndexType);
            renderPass.setVertexBuffer(0, gpuVertexBuffer);
            renderPass.drawIndexed(0, meshData.method_60822().comp_751());
        }
    }

    public static void prepareRenderPass(RenderPass renderPass, RenderPipeline renderPipeline) {
        renderPass.setPipeline(renderPipeline);
        if (RenderSystem.SCISSOR_STATE.isEnabled()) {
            renderPass.enableScissor(RenderSystem.SCISSOR_STATE);
        }
        Services.PLATFORM.getPlatformRenderHelper().onPrepareRenderPass(renderPass);
        for (int textureIndex = 0; textureIndex < 12; ++textureIndex) {
            GpuTexture gpuTexture = RenderSystem.getShaderTexture((int)textureIndex);
            if (gpuTexture == null) continue;
            renderPass.bindSampler("Sampler" + textureIndex, gpuTexture);
        }
        for (RenderPipeline.UniformDescription uniform : renderPipeline.getUniforms()) {
            if (!CustomUniforms.isCustom(uniform)) continue;
            Object value = CustomUniforms.getUniformValue(uniform);
            if (value instanceof float[]) {
                renderPass.setUniform(uniform.name(), (float[])value);
                continue;
            }
            if (value instanceof int[]) {
                renderPass.setUniform(uniform.name(), (int[])value);
                continue;
            }
            if (value instanceof Matrix4f) {
                renderPass.setUniform(uniform.name(), (Matrix4f)value);
                continue;
            }
            throw new IllegalArgumentException("Render pipeline contains a custom uniform with an invalid value type: " + String.valueOf(value));
        }
    }
}

