/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config.profile;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import xaero.lib.XaeroLib;
import xaero.lib.client.config.sync.ClientConfigSynchronizer;
import xaero.lib.common.player.ServerPlayerData;
import xaero.lib.platform.Services;

public final class ConfigProfileInfoPacket {
    private final List<Entry> entries;
    private final String defaultEnforcedProfileId;
    private final boolean reset;

    public ConfigProfileInfoPacket(List<Entry> entries, String defaultEnforcedProfileId, boolean reset) {
        this.entries = entries;
        this.defaultEnforcedProfileId = defaultEnforcedProfileId;
        this.reset = reset;
    }

    public ConfigProfileInfoPacket(String id, String name, String defaultEnforcedProfileId) {
        this(List.of(new Entry(id, name)), defaultEnforcedProfileId, false);
    }

    public ConfigProfileInfoPacket(List<Entry> entries) {
        this(entries, null, false);
    }

    public ConfigProfileInfoPacket(String id, String name) {
        this(List.of(new Entry(id, name)), null, false);
    }

    public void write(class_2540 buffer) {
        class_2487 tag = new class_2487();
        class_2499 entriesTag = new class_2499();
        for (Entry entry : this.entries) {
            class_2487 entryTag = new class_2487();
            entryTag.method_10582("i", entry.id);
            entryTag.method_10582("n", entry.name);
            entriesTag.add((Object)entryTag);
        }
        tag.method_10566("e", (class_2520)entriesTag);
        if (this.defaultEnforcedProfileId != null) {
            tag.method_10582("d", this.defaultEnforcedProfileId);
        }
        tag.method_10556("r", this.reset);
        buffer.method_10794((class_2520)tag);
    }

    public static ConfigProfileInfoPacket read(class_2540 buffer) {
        try {
            class_2487 tag = (class_2487)buffer.method_30616(class_2505.method_53898());
            if (tag == null) {
                return null;
            }
            ArrayList<Entry> entries = new ArrayList<Entry>();
            class_2499 entriesTag = tag.method_68569("e");
            for (class_2520 entryTag : entriesTag) {
                class_2487 entryTagCast = (class_2487)entryTag;
                String id = entryTagCast.method_68564("i", "");
                String name = entryTagCast.method_68564("n", "");
                entries.add(new Entry(id, name));
            }
            String defaultEnforcedProfileId = tag.method_68564("d", null);
            boolean reset = tag.method_68566("r", false);
            return new ConfigProfileInfoPacket(entries, defaultEnforcedProfileId, reset);
        }
        catch (Throwable t) {
            if (Services.PLATFORM.isDevelopmentEnvironment() || !Services.PLATFORM.isDedicatedServer()) {
                XaeroLib.LOGGER.error("packet error", t);
            }
            return null;
        }
    }

    public static final class Entry {
        public final String id;
        public final String name;

        public Entry(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    public static final class ClientHandler
    implements Consumer<ConfigProfileInfoPacket> {
        @Override
        public void accept(ConfigProfileInfoPacket packet) {
            try {
                ClientConfigSynchronizer synchronizer = XaeroLib.INSTANCE.getClient().getConfigSynchronizer();
                synchronizer.onConfigProfileInfoPacket(packet.entries, packet.defaultEnforcedProfileId, packet.reset);
            }
            catch (Throwable t) {
                XaeroLib.LOGGER.error("packet error", t);
            }
        }
    }

    public static final class ServerHandler
    implements BiConsumer<ConfigProfileInfoPacket, class_3222> {
        @Override
        public void accept(ConfigProfileInfoPacket packet, class_3222 player) {
            block2: {
                try {
                    ServerPlayerData.get(player).getConfigSynchronizer().onConfigProfileInfoPacket(packet.entries, packet.defaultEnforcedProfileId);
                }
                catch (Throwable t) {
                    if (!Services.PLATFORM.isDevelopmentEnvironment()) break block2;
                    XaeroLib.LOGGER.error("packet error", t);
                }
            }
        }
    }
}

