/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.platform.SourceFactor;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import net.minecraft.class_10789;
import net.minecraft.class_10799;
import net.minecraft.class_1921;
import net.minecraft.class_276;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_4668;
import net.minecraft.class_9801;
import xaero.lib.client.graphics.ICompositeRenderType;
import xaero.lib.client.graphics.ICompositeState;
import xaero.lib.client.graphics.shader.BuiltInCustomUniforms;
import xaero.lib.client.graphics.shader.LibShaders;
import xaero.lib.client.graphics.util.ImmediateRenderUtil;
import xaero.lib.common.reflection.util.ReflectionUtils;

public class XaeroRenderType
extends class_1921
implements ICompositeRenderType {
    private final class_1921 vanillaCompositeRenderType;
    private final RenderPipeline renderPipeline;
    private final class_1921.class_4688 compositeState;
    private final class_4668.class_4678 outputStateShard;
    public static final VertexFormat POSITION_COLOR_TEX = VertexFormat.builder().add("Position", VertexFormatElement.POSITION).add("Color", VertexFormatElement.COLOR).add("UV0", VertexFormatElement.UV0).build();
    protected static final BlendFunction DEFAULT_TRANSLUCENT_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA);
    protected static final BlendFunction LINES_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA);
    protected static final BlendFunction PREMULTIPLIED_TRANSPARENCY = new BlendFunction(SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE_MINUS_SRC_ALPHA);
    protected static final BlendFunction NEGATIVE_TRANSPARENCY = new BlendFunction(SourceFactor.ONE_MINUS_DST_COLOR, DestFactor.ZERO, SourceFactor.ZERO, DestFactor.ONE);
    protected static final BlendFunction DEST_TRANSPARENCY = new BlendFunction(SourceFactor.ONE, DestFactor.ZERO, SourceFactor.ZERO, DestFactor.ONE);
    protected static final BlendFunction REPLACE_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ZERO, SourceFactor.ONE, DestFactor.ZERO);
    protected static final BlendFunction ADD_ALPHA_TRANSPARENCY = new BlendFunction(SourceFactor.SRC_ALPHA, DestFactor.ONE_MINUS_SRC_ALPHA, SourceFactor.ONE, DestFactor.ONE);
    public static final RenderPipeline RP_POSITION_TEX_ALPHA;
    public static final RenderPipeline RP_POSITION_TEX_ALPHA_NO_BLEND;
    public static final RenderPipeline RP_POSITION_TEX_NO_ALPHA;
    public static final RenderPipeline RP_POSITION_TEX_NO_ALPHA_NO_DEPTH;
    public static final RenderPipeline RP_POSITION_TEX_NO_ALPHA_NO_BLEND;
    public static final RenderPipeline RP_POSITION_TEX_ALPHA_REPLACE;
    public static final RenderPipeline RP_POSITION_TEX_ALPHA_NO_CULL;
    public static final RenderPipeline RP_POSITION;
    public static final RenderPipeline RP_POSITION_NO_DEPTH;
    public static final RenderPipeline RP_NEGATIVE_COLOR;
    public static final RenderPipeline RP_ICON_OUTLINE;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_TRANSLUCENT;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_TRANSLUCENT_NO_DEPTH;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_TRANSLUCENT_CULL;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_PREMULTIPLIED;
    public static final RenderPipeline RP_POSITION_COLOR_TEX_NO_BLEND;
    public static final RenderPipeline RP_POSITION_COLOR_TRANSLUCENT;
    public static final RenderPipeline RP_POSITION_COLOR_NO_BLEND;
    public static final RenderPipeline RP_POSITION_COLOR_NO_CULL;
    public static final RenderPipeline RP_LINES;
    public static final RenderPipeline RP_DEPTH_CLEAR;
    public static final RenderPipeline RP_MAP;
    public static final RenderPipeline RP_MAP_BRANCH;
    public static final RenderPipeline RP_MAP_FRAME;
    public static final RenderPipeline RP_COLOR_FILLER;
    private static final Method compositeStateBuilderMethod;
    private static final Method compositeStateBuilderCreateCompositeStateMethod;
    private static final Method compositeStateBuilderSetTextureStateMethod;
    private static final Method compositeStateBuilderSetLightmapStateMethod;
    private static final Method compositeStateBuilderSetOverlayStateMethod;
    private static final Method compositeStateBuilderSetLayeringStateMethod;
    private static final Method compositeStateBuilderSetOutputStateMethod;
    private static final Method compositeStateBuilderSetTexturingStateMethod;
    private static final Method compositeStateBuilderSetLineStateMethod;
    private static final Method renderTypeCreateMethod;

    public XaeroRenderType(String name, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, RenderPipeline renderPipeline, class_4668.class_4678 outputStateShard, class_1921.class_4688 compositeState, class_1921 vanillaCompositeRenderType) {
        super(name, bufferSize, affectsCrumbling, sortOnUpload, () -> ((class_1921)vanillaCompositeRenderType).method_23516(), () -> ((class_1921)vanillaCompositeRenderType).method_23518());
        this.renderPipeline = renderPipeline;
        this.outputStateShard = outputStateShard;
        this.compositeState = compositeState;
        this.vanillaCompositeRenderType = vanillaCompositeRenderType;
    }

    public void method_60895(@Nonnull class_9801 meshData) {
        this.method_23516();
        ImmediateRenderUtil.drawImmediateMeshData(meshData, this.renderPipeline, this.outputStateShard.method_68491());
        this.method_23518();
    }

    @Nonnull
    public VertexFormat method_23031() {
        return this.vanillaCompositeRenderType.method_23031();
    }

    @Nonnull
    public VertexFormat.class_5596 method_23033() {
        return this.vanillaCompositeRenderType.method_23033();
    }

    @Override
    public RenderPipeline xaero_lib_getRenderPipeline() {
        return this.renderPipeline;
    }

    @Override
    public ICompositeState xaero_lib_getState() {
        return (ICompositeState)this.compositeState;
    }

    public static RenderPipeline getBasicRenderPipeline() {
        return class_10799.field_56906;
    }

    public static CustomStateBuilder getStateBuilder() {
        return new CustomStateBuilder((class_1921.class_4688.class_4689)ReflectionUtils.getReflectMethodValue(null, compositeStateBuilderMethod, new Object[0]));
    }

    public static class_1921 createRenderType(String name, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, RenderPipeline renderPipeline, CustomStateBuilder stateBuilder, class_1921.class_4750 outlineProperty) {
        class_1921.class_4688 compositeState = stateBuilder.createCompositeState(outlineProperty);
        class_1921 normalRenderType = (class_1921)ReflectionUtils.getReflectMethodValue(null, renderTypeCreateMethod, name, bufferSize, affectsCrumbling, sortOnUpload, renderPipeline, compositeState);
        return new XaeroRenderType(name, bufferSize, affectsCrumbling, sortOnUpload, renderPipeline, stateBuilder.getOutputState(), compositeState, normalRenderType);
    }

    public static class_276 getOutputStateTarget(Object outputStateShard) {
        return ((class_4668.class_4678)outputStateShard).method_68491();
    }

    static {
        try {
            Class<?> compositeStateClass = ReflectionUtils.getClassForName("net.minecraft.class_1921$class_4688", "net.minecraft.client.renderer.RenderType$CompositeState");
            compositeStateBuilderMethod = ReflectionUtils.getMethodReflection(compositeStateClass, "builder", "method_23598", "()Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110628_", new Class[0]);
            compositeStateBuilderCreateCompositeStateMethod = ReflectionUtils.getMethodReflection(class_1921.class_4688.class_4689.class, "createCompositeState", "method_24297", "(Lnet/minecraft/class_1921$class_4750;)Lnet/minecraft/class_1921$class_4688;", "m_110689_", class_1921.class_4750.class);
            compositeStateBuilderSetTextureStateMethod = ReflectionUtils.getMethodReflection(class_1921.class_4688.class_4689.class, "setTextureState", "method_34577", "(Lnet/minecraft/class_4668$class_5939;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_173290_", class_4668.class_5939.class);
            compositeStateBuilderSetLightmapStateMethod = ReflectionUtils.getMethodReflection(class_1921.class_4688.class_4689.class, "setLightmapState", "method_23608", "(Lnet/minecraft/class_4668$class_4676;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110671_", class_4668.class_4676.class);
            compositeStateBuilderSetOverlayStateMethod = ReflectionUtils.getMethodReflection(class_1921.class_4688.class_4689.class, "setOverlayState", "method_23611", "(Lnet/minecraft/class_4668$class_4679;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110677_", class_4668.class_4679.class);
            compositeStateBuilderSetLayeringStateMethod = ReflectionUtils.getMethodReflection(class_1921.class_4688.class_4689.class, "setLayeringState", "method_23607", "(Lnet/minecraft/class_4668$class_4675;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110669_", class_4668.class_4675.class);
            compositeStateBuilderSetOutputStateMethod = ReflectionUtils.getMethodReflection(class_1921.class_4688.class_4689.class, "setOutputState", "method_23610", "(Lnet/minecraft/class_4668$class_4678;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110675_", class_4668.class_4678.class);
            compositeStateBuilderSetTexturingStateMethod = ReflectionUtils.getMethodReflection(class_1921.class_4688.class_4689.class, "setTexturingState", "method_23614", "(Lnet/minecraft/class_4668$class_4684;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110683_", class_4668.class_4684.class);
            compositeStateBuilderSetLineStateMethod = ReflectionUtils.getMethodReflection(class_1921.class_4688.class_4689.class, "setLineState", "method_23609", "(Lnet/minecraft/class_4668$class_4677;)Lnet/minecraft/class_1921$class_4688$class_4689;", "m_110673_", class_4668.class_4677.class);
            renderTypeCreateMethod = ReflectionUtils.getMethodReflection(class_1921.class, "create", "method_24049", "(Ljava/lang/String;IZZLcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/class_1921$class_4688;)Lnet/minecraft/class_1921$class_4687;", "m_173215_", String.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, RenderPipeline.class, class_1921.class_4688.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        RenderPipeline.Snippet MATRICES_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[0]).withUniform("DynamicTransforms", class_10789.field_60031).withUniform("Projection", class_10789.field_60031).buildSnippet();
        RenderPipeline.Snippet MATRICES_FOG_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withUniform("Fog", class_10789.field_60031).buildSnippet();
        RenderPipeline.Snippet POSITION_TEX_NO_ALPHA_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(LibShaders.POSITION_TEX_NO_ALPHA_TEST).withFragmentShader(LibShaders.POSITION_TEX_NO_ALPHA_TEST).withVertexFormat(class_290.field_1585, VertexFormat.class_5596.field_27382).withSampler("Sampler0").buildSnippet();
        RP_POSITION_TEX_NO_ALPHA = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_TEX_NO_ALPHA_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos_tex_no_alpha")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).build();
        RP_POSITION_TEX_NO_ALPHA_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_TEX_NO_ALPHA_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos_tex_no_alpha_no_depth")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        RP_POSITION_TEX_NO_ALPHA_NO_BLEND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_TEX_NO_ALPHA_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos_tex_no_alpha_no_blend")).withoutBlend().build();
        RenderPipeline.Snippet RP_POSITION_TEX_ALPHA_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(LibShaders.POSITION_TEX_ALPHA_TEST).withFragmentShader(LibShaders.POSITION_TEX_ALPHA_TEST).withUniform(BuiltInCustomUniforms.DISCARD_ALPHA.name(), BuiltInCustomUniforms.DISCARD_ALPHA.type()).withVertexFormat(class_290.field_1585, VertexFormat.class_5596.field_27382).withSampler("Sampler0").buildSnippet();
        RP_POSITION_TEX_ALPHA = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos_tex_alpha")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).build();
        RP_ICON_OUTLINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/icon_outline")).withBlend(ADD_ALPHA_TRANSPARENCY).build();
        RP_POSITION_TEX_ALPHA_NO_BLEND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos_tex_alpha_no_blend")).withoutBlend().build();
        RP_POSITION_TEX_ALPHA_REPLACE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos_tex_alpha_replace")).withBlend(REPLACE_TRANSPARENCY).build();
        RP_POSITION_TEX_ALPHA_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RP_POSITION_TEX_ALPHA_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos_tex_alpha_no_cull")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withCull(false).build();
        RP_POSITION = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos")).withVertexShader("core/position").withFragmentShader("core/position").withVertexFormat(class_290.field_1592, VertexFormat.class_5596.field_27382).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).build();
        RP_POSITION_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos")).withVertexShader("core/position").withFragmentShader("core/position").withVertexFormat(class_290.field_1592, VertexFormat.class_5596.field_27382).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        RP_NEGATIVE_COLOR = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_FOG_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos_negative_color")).withVertexShader("core/position").withFragmentShader("core/position").withVertexFormat(class_290.field_1592, VertexFormat.class_5596.field_27382).withBlend(NEGATIVE_TRANSPARENCY).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        RenderPipeline.Snippet POSITION_COLOR_TEX_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(LibShaders.POSITION_COLOR_TEX).withFragmentShader(LibShaders.POSITION_COLOR_TEX).withVertexFormat(POSITION_COLOR_TEX, VertexFormat.class_5596.field_27382).withSampler("Sampler0").buildSnippet();
        RenderPipeline.Snippet POSITION_COLOR_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(LibShaders.POSITION_COLOR).withFragmentShader(LibShaders.POSITION_COLOR).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27382).buildSnippet();
        RenderPipeline.Snippet POSITION_COLOR_NO_ALPHA_SNIPPET = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withVertexShader(LibShaders.POSITION_COLOR_NO_ALPHA_TEST).withFragmentShader(LibShaders.POSITION_COLOR_NO_ALPHA_TEST).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27382).buildSnippet();
        RP_POSITION_COLOR_TEX_TRANSLUCENT = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos_col_tex_translucent")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withCull(false).build();
        RP_POSITION_COLOR_TEX_TRANSLUCENT_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos_col_tex_translucent_cull")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).build();
        RP_POSITION_COLOR_TEX_TRANSLUCENT_NO_DEPTH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos_col_tex_translucent_no_depth")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withCull(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build();
        RP_POSITION_COLOR_TEX_PREMULTIPLIED = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos_col_tex_premultiplied")).withBlend(PREMULTIPLIED_TRANSPARENCY).withCull(false).build();
        RP_POSITION_COLOR_TEX_NO_BLEND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos_col_tex_no_blend")).withoutBlend().build();
        RP_POSITION_COLOR_TRANSLUCENT = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos_col_translucent")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).build();
        RP_POSITION_COLOR_NO_BLEND = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos_col_no_blend")).withoutBlend().build();
        RP_POSITION_COLOR_NO_CULL = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/pos_col_translucent")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withCull(false).build();
        RP_LINES = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/lines")).withVertexShader(LibShaders.FRAMEBUFFER_LINES).withFragmentShader(LibShaders.FRAMEBUFFER_LINES).withUniform(BuiltInCustomUniforms.FRAME_SIZE.name(), BuiltInCustomUniforms.FRAME_SIZE.type()).withVertexFormat(class_290.field_29337, VertexFormat.class_5596.field_27377).withBlend(LINES_TRANSPARENCY).build();
        RP_DEPTH_CLEAR = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_NO_ALPHA_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/depth_clear")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withDepthTestFunction(DepthTestFunction.GREATER_DEPTH_TEST).withColorWrite(false, false).build();
        RP_MAP = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/map")).withVertexShader(LibShaders.WORLD_MAP).withFragmentShader(LibShaders.WORLD_MAP).withVertexFormat(class_290.field_1585, VertexFormat.class_5596.field_27382).withSampler("Sampler0").withUniform(BuiltInCustomUniforms.BRIGHTNESS.name(), BuiltInCustomUniforms.BRIGHTNESS.type()).withUniform(BuiltInCustomUniforms.WITH_LIGHT.name(), BuiltInCustomUniforms.WITH_LIGHT.type()).withBlend(DEST_TRANSPARENCY).withCull(false).build();
        RP_MAP_BRANCH = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{MATRICES_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/map_branch")).withVertexShader(LibShaders.WORLD_MAP_BRANCH).withFragmentShader(LibShaders.WORLD_MAP_BRANCH).withVertexFormat(class_290.field_1585, VertexFormat.class_5596.field_27382).withSampler("Sampler0").withoutBlend().withCull(false).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).withDepthWrite(false).build();
        RP_MAP_FRAME = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_TEX_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/map_frame")).withBlend(DEST_TRANSPARENCY).withCull(false).withDepthWrite(false).build();
        RP_COLOR_FILLER = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{POSITION_COLOR_SNIPPET}).withLocation(class_2960.method_60655((String)"xaerolib", (String)"pipeline/color_filler")).withBlend(DEFAULT_TRANSLUCENT_TRANSPARENCY).withDepthWrite(false).build();
    }

    public static final class CustomStateBuilder {
        private final class_1921.class_4688.class_4689 original;
        private class_4668.class_4678 outputState = class_4668.field_21358;

        private CustomStateBuilder(class_1921.class_4688.class_4689 original) {
            this.original = original;
        }

        public CustomStateBuilder setTextureState(class_4668.class_5939 textureState) {
            ReflectionUtils.getReflectMethodValue(this.original, compositeStateBuilderSetTextureStateMethod, textureState);
            return this;
        }

        public CustomStateBuilder setLightmapState(class_4668.class_4676 lightmapState) {
            ReflectionUtils.getReflectMethodValue(this.original, compositeStateBuilderSetLightmapStateMethod, lightmapState);
            return this;
        }

        public CustomStateBuilder setOverlayState(class_4668.class_4679 overlayState) {
            ReflectionUtils.getReflectMethodValue(this.original, compositeStateBuilderSetOverlayStateMethod, overlayState);
            return this;
        }

        public CustomStateBuilder setLayeringState(class_4668.class_4675 layeringState) {
            ReflectionUtils.getReflectMethodValue(this.original, compositeStateBuilderSetLayeringStateMethod, layeringState);
            return this;
        }

        public CustomStateBuilder setOutputState(class_4668.class_4678 outputState) {
            ReflectionUtils.getReflectMethodValue(this.original, compositeStateBuilderSetOutputStateMethod, outputState);
            this.outputState = outputState;
            return this;
        }

        public CustomStateBuilder setTexturingState(class_4668.class_4684 texturingState) {
            ReflectionUtils.getReflectMethodValue(this.original, compositeStateBuilderSetTexturingStateMethod, texturingState);
            return this;
        }

        public CustomStateBuilder setLineState(class_4668.class_4677 lineState) {
            ReflectionUtils.getReflectMethodValue(this.original, compositeStateBuilderSetLineStateMethod, lineState);
            return this;
        }

        public class_4668.class_4678 getOutputState() {
            return this.outputState;
        }

        private class_1921.class_4688 createCompositeState(class_1921.class_4750 outlineProperty) {
            return (class_1921.class_4688)ReflectionUtils.getReflectMethodValue(this.original, compositeStateBuilderCreateCompositeStateMethod, outlineProperty);
        }
    }
}

