/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_11266;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import xaero.lib.XaeroLib;

public class DynamicImmediateGpuBuffer {
    private GpuBuffer buffer;
    private final List<GpuBuffer> buffersToDelete;
    private int position;
    private final int usageFlags;
    private final boolean usesImmutableBufferStorage;

    public DynamicImmediateGpuBuffer(int initialSize, int usageFlags) {
        this.usageFlags = usageFlags;
        this.buffersToDelete = new ArrayList<GpuBuffer>();
        if (RenderSystem.getDevice().getBackendName().equals("OpenGL")) {
            HashSet storageTestSet = new HashSet();
            class_11266.method_71019((GLCapabilities)GL.getCapabilities(), storageTestSet);
            this.usesImmutableBufferStorage = storageTestSet.contains("GL_ARB_buffer_storage");
        } else {
            this.usesImmutableBufferStorage = true;
        }
        this.ensureBufferSize(initialSize);
    }

    private void ensureBufferSize(int requiredSize) {
        if (this.buffer != null && this.buffer.size() >= requiredSize) {
            return;
        }
        int newSize = this.buffer == null ? requiredSize : Math.max(requiredSize, this.buffer.size() * 2);
        GpuDevice gpuDevice = RenderSystem.getDevice();
        int additionalUsageFlags = this.usesImmutableBufferStorage ? 0 : 6;
        GpuBuffer resizedBuffer = gpuDevice.createBuffer(null, this.usageFlags | 8 | additionalUsageFlags, newSize);
        if (this.buffer != null) {
            this.buffersToDelete.add(this.buffer);
            XaeroLib.LOGGER.info("Resized a dynamic immediate buffer to {}!", (Object)newSize);
        }
        this.buffer = resizedBuffer;
        this.position = 0;
    }

    public GpuBufferSlice allocateSlice(int size) {
        this.ensureBufferSize(this.position + size);
        GpuBufferSlice slice = this.buffer.slice(this.position, size);
        this.position += size;
        return slice;
    }

    public void clear() {
        this.position = 0;
        for (GpuBuffer gpuBuffer : this.buffersToDelete) {
            gpuBuffer.close();
        }
        this.buffersToDelete.clear();
    }

    public GpuBuffer getGpuBuffer() {
        return this.buffer;
    }
}

