/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.config;

import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.config.EditConfigScreen;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.option.ConfigOption;

public class EditStringConfigOptionScreen<T>
extends ScreenBase {
    private class_342 editBox;
    private class_4185 confirmButton;
    private final Config config;
    private final Config enforcedConfig;
    private final ConfigOption<T> configOption;
    private final boolean allowEmpty;
    private final boolean emptyMeansNull;
    private final Runnable postConfirmAction;
    private boolean valid;
    private String currentValue;
    private class_2561 enforcedValueLabel;
    protected boolean shouldRenderEscapeScreen;

    public EditStringConfigOptionScreen(class_437 parent, class_437 escape, Config config, Config enforcedConfig, ConfigOption<T> configOption, boolean allowEmpty, boolean emptyMeansNull, Runnable postConfirmAction) {
        super(parent, escape, configOption.getDisplayName());
        this.config = config;
        this.enforcedConfig = enforcedConfig;
        this.configOption = configOption;
        this.allowEmpty = allowEmpty;
        this.emptyMeansNull = emptyMeansNull;
        this.postConfirmAction = postConfirmAction;
        T value = config.get(configOption);
        this.currentValue = value == null ? "" : configOption.getValueType().getIoCodec().encode(value, null, configOption);
        this.shouldRenderEscapeScreen = false;
        this.canSkipWorldRender = false;
        if (parent instanceof EditConfigScreen) {
            EditConfigScreen configScreen = (EditConfigScreen)parent;
            this.shouldRenderEscapeScreen = configScreen.shouldRenderEscapeScreen;
            this.canSkipWorldRender = configScreen.canSkipWorldRender();
        }
    }

    @Override
    public void method_25426() {
        super.method_25426();
        Object enforcedValue = this.enforcedConfig == null ? null : (Object)this.enforcedConfig.get(this.configOption);
        this.enforcedValueLabel = enforcedValue == null ? null : class_2561.method_43469((String)"gui.xaero_config_value_enforced_string_edit", (Object[])new Object[]{this.configOption.getValueType().getIoCodec().encode(enforcedValue, null, this.configOption)}).method_27692(class_124.field_1054);
        this.editBox = new class_342(this.field_22793, this.field_22789 / 2 - 100, this.field_22790 / 7 + 29 - 2, 200, 20, this.configOption.getDisplayName());
        this.editBox.method_1880(this.configOption.getValueType().getIoCodec().getMaxStringLength());
        this.method_25395((class_364)this.editBox);
        this.editBox.method_25365(true);
        this.editBox.method_1852(this.currentValue);
        this.editBox.method_1863(this::onChange);
        this.method_37063((class_364)this.editBox);
        this.confirmButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.xaero_confirm"), b -> this.confirm()).method_46434(this.field_22789 / 2 - 105, this.field_22790 / 7 + 29 + 48, 100, 20).method_46431();
        this.method_37063((class_364)this.confirmButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.xaero_cancel"), b -> this.goBack()).method_46434(this.field_22789 / 2 + 5, this.field_22790 / 7 + 29 + 48, 100, 20).method_46431());
        this.valid = true;
        this.updateConfirmButton();
    }

    private void onChange(String s) {
        this.currentValue = s;
        this.valid = true;
        if (this.editBox.method_1882().isEmpty()) {
            this.valid = this.allowEmpty;
            this.updateConfirmButton();
            return;
        }
        try {
            T value = this.configOption.getValueType().getIoCodec().decode(s, null, this.configOption);
            this.valid = this.configOption.isValidValue(value);
        }
        catch (Throwable t) {
            this.valid = false;
        }
        this.updateConfirmButton();
    }

    private boolean canConfirm() {
        return this.valid;
    }

    private void updateConfirmButton() {
        this.confirmButton.field_22763 = this.canConfirm();
    }

    public void confirm() {
        Object value;
        if (!this.canConfirm()) {
            return;
        }
        Object t = value = this.editBox.method_1882().isEmpty() && this.emptyMeansNull ? null : (Object)this.configOption.getValueType().getIoCodec().decode(this.editBox.method_1882(), null, this.configOption);
        if (value != null && !this.configOption.isValidValue(value)) {
            return;
        }
        this.config.set(this.configOption, value);
        this.postConfirmAction.run();
        this.goBack();
    }

    public boolean method_25404(int keyCode, int par2, int par3) {
        boolean result = super.method_25404(keyCode, par2, par3);
        if (keyCode == 257 && this.canConfirm()) {
            this.confirmButton.method_25348(0.0, 0.0);
            return true;
        }
        return result;
    }

    @Override
    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
        if (this.shouldRenderEscapeScreen) {
            this.renderEscapeScreen(guiGraphics, 0, 0, f);
        }
        super.method_25420(guiGraphics, i, j, f);
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partial) {
        super.method_25394(guiGraphics, mouseX, mouseY, partial);
        if (this.enforcedValueLabel != null) {
            guiGraphics.method_27534(this.field_22793, this.enforcedValueLabel, this.field_22789 / 2, this.field_22790 / 7 + 29 - 22, -1);
        }
        guiGraphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, this.field_22790 / 7 + 29 - 42, -1);
    }

    @Override
    public void method_25419() {
        this.onExit(this.parent);
    }
}

