/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet;

import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import xaero.lib.common.packet.ClientPacketHandlerFabric;
import xaero.lib.common.packet.PacketHandlerFull;
import xaero.lib.common.packet.ServerPacketReceiverFabric;
import xaero.lib.common.packet.payload.PacketPayload;
import xaero.lib.common.packet.payload.PacketPayloadCodec;
import xaero.lib.common.packet.type.PacketTypeManager;

public class PacketHandlerFabric
extends PacketHandlerFull {
    private ClientPacketHandlerFabric clientPacketHandlerFabric;

    private PacketHandlerFabric(class_2960 channelId, PacketTypeManager packetTypeManager, class_8710.class_9154<PacketPayload<?>> type) {
        super(channelId, packetTypeManager, type);
    }

    private void setClientPacketHandlerFabric(ClientPacketHandlerFabric clientPacketHandlerFabric) {
        this.clientPacketHandlerFabric = clientPacketHandlerFabric;
    }

    @Override
    public <T> void sendToServer(T packet) {
        this.clientPacketHandlerFabric.sendToServer(packet);
    }

    @Override
    public <T> void sendToPlayer(class_3222 player, T packet) {
        ServerPlayNetworking.send((class_3222)player, new PacketPayload<T>(this.packetTypeManager.getType(packet), packet, this.type));
    }

    public static class Builder
    extends PacketHandlerFull.Builder<Builder> {
        private Builder() {
        }

        @Override
        public Builder setDefault() {
            return this;
        }

        @Override
        public PacketHandlerFabric build() {
            return (PacketHandlerFabric)super.build();
        }

        @Override
        protected PacketHandlerFull buildInternal(PacketTypeManager packetTypeManager, class_8710.class_9154<PacketPayload<?>> type) {
            PacketHandlerFabric result = new PacketHandlerFabric(this.channelId, packetTypeManager, type);
            PacketPayloadCodec payloadCodec = new PacketPayloadCodec(result);
            PayloadTypeRegistry.playS2C().register(type, (class_9139)payloadCodec);
            PayloadTypeRegistry.playC2S().register(type, (class_9139)payloadCodec);
            ServerPlayNetworking.registerGlobalReceiver(type, (ServerPlayNetworking.PlayPayloadHandler)new ServerPacketReceiverFabric(result));
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                ClientPacketHandlerFabric clientHandler = new ClientPacketHandlerFabric(result);
                result.setClientPacketHandlerFabric(clientHandler);
                clientHandler.registerOnClient();
            }
            return result;
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

