/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import xaero.lib.XaeroLib;
import xaero.lib.platform.Services;

public abstract class XaeroPacket
implements IMessage {
    protected boolean failedToRead;

    public final void fromBytes(ByteBuf buf) {
        try {
            this.failedToRead = false;
            this.read(new PacketBuffer(buf));
        }
        catch (Throwable t) {
            if (Services.PLATFORM.isDevelopmentEnvironment() || !Services.PLATFORM.isDedicatedServer()) {
                XaeroLib.LOGGER.error("packet error", t);
            }
            this.failedToRead = true;
        }
    }

    public final void toBytes(ByteBuf buf) {
        this.write(new PacketBuffer(buf));
    }

    protected abstract void write(PacketBuffer var1);

    protected abstract void read(PacketBuffer var1);

    public boolean isFailedToRead() {
        return this.failedToRead;
    }

    protected NBTTagCompound readTag(PacketBuffer buf, NBTSizeTracker sizeTracker) {
        int i = buf.readerIndex();
        byte firstByte = buf.readByte();
        if (firstByte == 0) {
            this.failedToRead = true;
            return null;
        }
        buf.readerIndex(i);
        try {
            return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream((ByteBuf)buf), (NBTSizeTracker)sizeTracker);
        }
        catch (IOException e) {
            this.failedToRead = true;
            return null;
        }
    }

    protected NBTTagCompound readUnlimitedTag(PacketBuffer buf) {
        return this.readTag(buf, NBTSizeTracker.field_152451_a);
    }

    protected NBTTagCompound readDefaultTag(PacketBuffer buf) {
        return this.readTag(buf, new NBTSizeTracker(0x200000L));
    }
}

