/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import xaero.lib.XaeroLib;
import xaero.lib.common.packet.config.AbstractConfigPacket;

public final class ClientboundEnforcedConfigPacket
extends AbstractConfigPacket<ClientboundEnforcedConfigPacket> {
    private boolean reset;

    public ClientboundEnforcedConfigPacket(List<AbstractConfigPacket.OptionEntry> entries, boolean reset) {
        super(entries);
        this.reset = reset;
    }

    public ClientboundEnforcedConfigPacket() {
    }

    @Override
    protected void writeExtra(NBTTagCompound tag) {
        tag.func_74757_a("r", this.reset);
    }

    @Override
    public void read(PacketBuffer buffer) {
        NBTTagCompound tag = this.readUnlimitedTag(buffer);
        if (tag == null) {
            return;
        }
        this.readOptions(tag);
        this.reset = tag.func_74767_n("r");
    }

    public static final class ClientHandler
    implements Consumer<ClientboundEnforcedConfigPacket> {
        @Override
        public void accept(ClientboundEnforcedConfigPacket packet) {
            try {
                XaeroLib.INSTANCE.getClient().getConfigSynchronizer().onEnforcedConfigPacket(packet.reset, packet.getEntries());
            }
            catch (Throwable t) {
                XaeroLib.LOGGER.error("packet error", t);
            }
        }
    }
}

