/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config.profile;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import xaero.lib.XaeroLib;
import xaero.lib.common.packet.config.AbstractConfigPacket;
import xaero.lib.common.player.ServerPlayerData;
import xaero.lib.platform.Services;

public final class ConfigProfileEditPacket
extends AbstractConfigPacket<ConfigProfileEditPacket> {
    private String profileId;

    public ConfigProfileEditPacket(String profileId, List<AbstractConfigPacket.OptionEntry> entries) {
        super(entries);
        this.profileId = profileId;
    }

    public ConfigProfileEditPacket() {
    }

    @Override
    protected void writeExtra(NBTTagCompound tag) {
        tag.func_74778_a("i", this.profileId);
    }

    @Override
    public void read(PacketBuffer buffer) {
        NBTTagCompound tag = this.readTag(buffer, new NBTSizeTracker(0x800000L));
        if (tag == null) {
            return;
        }
        this.readOptions(tag);
        this.profileId = tag.func_74779_i("i");
    }

    public static final class ServerHandler
    implements BiConsumer<ConfigProfileEditPacket, EntityPlayerMP> {
        @Override
        public void accept(ConfigProfileEditPacket message, EntityPlayerMP player) {
            block2: {
                try {
                    ServerPlayerData.get(player).getConfigSynchronizer().onEditProfilePacket(message.profileId, message.getEntries());
                }
                catch (Throwable t) {
                    if (!Services.PLATFORM.isDevelopmentEnvironment()) break block2;
                    XaeroLib.LOGGER.error("packet error", t);
                }
            }
        }
    }

    public static final class ClientHandler
    implements Consumer<ConfigProfileEditPacket> {
        @Override
        public void accept(ConfigProfileEditPacket message) {
            try {
                XaeroLib.INSTANCE.getClient().getConfigSynchronizer().onEditProfilePacket(message.profileId, message.getEntries());
            }
            catch (Throwable t) {
                XaeroLib.LOGGER.error("packet error", t);
            }
        }
    }
}

