/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics.util;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class ImmediateRenderUtil {
    public static void coloredRectangle(float x1, float y1, float x2, float y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexBuffer = tessellator.getBuffer();
        vertexBuffer.begin(7, DefaultVertexFormats.POSITION_COLOR);
        vertexBuffer.pos((double)x1, (double)y2, 0.0).color(r, g, b, a).endVertex();
        vertexBuffer.pos((double)x2, (double)y2, 0.0).color(r, g, b, a).endVertex();
        vertexBuffer.pos((double)x2, (double)y1, 0.0).color(r, g, b, a).endVertex();
        vertexBuffer.pos((double)x1, (double)y1, 0.0).color(r, g, b, a).endVertex();
        tessellator.draw();
    }

    public static void texturedRect(float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        ImmediateRenderUtil.texturedRect(x, y, textureX, textureY, width, height, theight, factor, 0.0f, true);
    }

    public static void texturedRect(float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha, boolean blend) {
        if (discardAlpha < 0.0f) {
            GlStateManager.disableAlpha();
        } else {
            GlStateManager.enableAlpha();
            GlStateManager.alphaFunc((int)516, (float)discardAlpha);
        }
        if (blend) {
            GlStateManager.enableBlend();
        } else {
            GlStateManager.disableBlend();
        }
        ImmediateRenderUtil.texturedRectInternal(x, y, textureX, textureY, width, height, theight, factor);
        GlStateManager.enableBlend();
        GlStateManager.enableAlpha();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
    }

    private static void texturedRectInternal(float x, float y, int textureX, int textureY, float width, float height, float textureH, float factor) {
        float f;
        float f1 = f = 1.0f / factor;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexBuffer = tessellator.getBuffer();
        vertexBuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        vertexBuffer.pos((double)(x + 0.0f), (double)(y + height), 0.0).tex((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1)).endVertex();
        vertexBuffer.pos((double)(x + width), (double)(y + height), 0.0).tex((double)(((float)textureX + width) * f), (double)((float)(textureY + 0) * f1)).endVertex();
        vertexBuffer.pos((double)(x + width), (double)(y + 0.0f), 0.0).tex((double)(((float)textureX + width) * f), (double)(((float)textureY + textureH) * f1)).endVertex();
        vertexBuffer.pos((double)(x + 0.0f), (double)(y + 0.0f), 0.0).tex((double)((float)(textureX + 0) * f), (double)(((float)textureY + textureH) * f1)).endVertex();
        tessellator.draw();
    }

    public static void drawOutlineLayer(float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        ImmediateRenderUtil.texturedRectInternal(x, y, textureX, textureY, width, height, theight, factor);
        GlStateManager.enableAlpha();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
    }
}

