/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.widget.CycleButtonOption;
import xaero.lib.client.gui.widget.IClickableWidget;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.XaeroCycleButton;
import xaero.lib.client.gui.widget.XaeroSliderWidget;
import xaero.lib.common.config.util.ConfigConstants;
import xaero.lib.common.config.util.ConfigUtils;
import xaero.lib.common.gui.widget.TooltipInfo;

public class CustomSettingEntry<T>
implements ISettingEntry {
    private final BooleanSupplier allowNull;
    private final ITextComponent name;
    private final TooltipInfo tooltipInfo;
    private final boolean slider;
    private Supplier<T> currentValueSupplier;
    private final int minIndex;
    private final int maxIndex;
    private final IntFunction<T> indexReader;
    private final Function<T, ITextComponent> valueNamer;
    private final BiConsumer<T, T> onValueChange;
    private final BooleanSupplier activeSupplier;

    public CustomSettingEntry(BooleanSupplier allowNull, ITextComponent name, TooltipInfo tooltipInfo, boolean slider, Supplier<T> currentValueSupplier, int minIndex, int maxIndex, IntFunction<T> indexReader, Function<T, ITextComponent> valueNamer, BiConsumer<T, T> onValueChange, BooleanSupplier activeSupplier) {
        this.allowNull = allowNull;
        this.name = name;
        this.tooltipInfo = tooltipInfo;
        this.slider = slider;
        this.currentValueSupplier = currentValueSupplier;
        this.minIndex = minIndex;
        this.maxIndex = maxIndex;
        this.indexReader = indexReader;
        this.valueNamer = valueNamer;
        this.onValueChange = onValueChange;
        this.activeSupplier = activeSupplier;
    }

    @Override
    public String getStringForSearch() {
        ITextComponent displayName = this.name;
        T currentValue = this.currentValueSupplier.get();
        String result = ConfigUtils.optionNameValue(displayName, currentValue == null ? ConfigConstants.UNSPECIFIED : this.valueNamer.apply(currentValue)).getFormattedText();
        if (displayName instanceof TextComponentTranslation) {
            result = result + " " + ((TextComponentTranslation)displayName).getKey().replace("gui.xaero", "");
        }
        if (this.tooltipInfo != null) {
            result = result + " " + this.tooltipInfo.text.getFormattedText();
            if (this.tooltipInfo.text instanceof TextComponentTranslation) {
                result = result + " " + ((TextComponentTranslation)this.tooltipInfo.text).getKey().replace("gui.xaero", "");
            }
        }
        return result;
    }

    @Override
    public GuiButton createWidget(int x, int y, int w, int screenWidth) {
        GuiButton result;
        final ArrayList<CycleButtonOption<T>> values = new ArrayList<CycleButtonOption<T>>();
        CycleButtonOption<T> initialOption = null;
        int initialOptionIndex = -1;
        if (this.allowNull.getAsBoolean()) {
            values.add(new CycleButtonOption<Object>(null));
        }
        T currentValue = this.currentValueSupplier.get();
        for (int i = this.minIndex; i <= this.maxIndex; ++i) {
            T value = this.indexReader.apply(i);
            CycleButtonOption<T> option = new CycleButtonOption<T>(value);
            values.add(option);
            if (!Objects.equals(value, currentValue)) continue;
            initialOption = option;
            initialOptionIndex = values.size() - 1;
        }
        if (initialOption == null) {
            initialOption = (CycleButtonOption<T>)values.get(0);
            initialOptionIndex = 0;
        }
        final ITextComponent displayName = this.name;
        if (!this.slider) {
            result = XaeroCycleButton.builder(new Function<CycleButtonOption<T>, ITextComponent>(){

                @Override
                public ITextComponent apply(CycleButtonOption<T> co) {
                    return CustomSettingEntry.this.getValueName(co.get());
                }
            }).withValues(values).withInitialValue(initialOption).create(x, y, w, 20, displayName, new BiConsumer<XaeroCycleButton<CycleButtonOption<T>>, CycleButtonOption<T>>(){

                @Override
                public void accept(XaeroCycleButton<CycleButtonOption<T>> b, CycleButtonOption<T> o) {
                    Object oldValue = CustomSettingEntry.this.currentValueSupplier.get();
                    if (CustomSettingEntry.this.onValueChange != null) {
                        CustomSettingEntry.this.onValueChange.accept(oldValue, o.get());
                    }
                }
            });
        } else {
            Supplier<String> labelGetter = new Supplier<String>(){

                @Override
                public String get() {
                    return ConfigUtils.optionNameValue(displayName, CustomSettingEntry.this.getValueName(CustomSettingEntry.this.currentValueSupplier.get())).getFormattedText();
                }
            };
            double initialSliderValue = (double)initialOptionIndex / (double)(values.size() - 1);
            result = new XaeroSliderWidget(x, y, w, 20, (String)labelGetter.get(), initialSliderValue, new DoubleConsumer(){

                @Override
                public void accept(double newSliderValue) {
                    int selectedOptionIndex = (int)Math.round(newSliderValue * (double)(values.size() - 1));
                    CycleButtonOption selectedOption = (CycleButtonOption)values.get(selectedOptionIndex);
                    Object oldValue = CustomSettingEntry.this.currentValueSupplier.get();
                    if (CustomSettingEntry.this.onValueChange != null) {
                        CustomSettingEntry.this.onValueChange.accept(oldValue, selectedOption.get());
                    }
                }
            }, labelGetter, screenWidth);
        }
        result.enabled = this.activeSupplier.getAsBoolean();
        if (this.tooltipInfo != null) {
            ((IClickableWidget)result).setXaero_tooltip(new Tooltip(this.tooltipInfo));
        }
        return result;
    }

    public ITextComponent getValueName(T value) {
        if (value == null) {
            return ConfigConstants.UNSPECIFIED;
        }
        return this.valueNamer.apply(value);
    }
}

