/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import xaero.lib.XaeroLib;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.util.GuiUtils;
import xaero.lib.client.gui.widget.GuiActionButton;
import xaero.lib.client.gui.widget.MyTinyButton;
import xaero.lib.client.gui.widget.online.GuiWidgetButton;
import xaero.lib.client.gui.widget.online.WidgetScreen;
import xaero.lib.common.util.KeySortableByOther;

public abstract class GuiSettings
extends ScreenBase
implements WidgetScreen {
    protected int entriesPerPage = 12;
    protected ISettingEntry[] entries;
    private boolean buttonClicked;
    protected String entryFilter = "";
    private boolean foundSomething;
    protected ITextComponent screenTitle;
    protected int page;
    protected int maxPage;
    private MyTinyButton nextButton;
    private MyTinyButton prevButton;
    protected GuiTextField searchField;
    protected boolean canSearch = true;
    private boolean shouldRefocusSearch;
    protected boolean confirmButton;

    public GuiSettings(ITextComponent title, GuiScreen backScreen, GuiScreen escScreen) {
        this(title, backScreen, escScreen, false);
    }

    public GuiSettings(ITextComponent title, GuiScreen backScreen, GuiScreen escScreen, boolean confirmButton) {
        super(backScreen, escScreen, title);
        this.confirmButton = confirmButton;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.screenTitle = this.title;
        this.buttonList.clear();
        if (this.confirmButton) {
            this.buttonList.add(new GuiActionButton(this.width / 2 - 105, this.height / 6 + 168, 100, 20, I18n.format((String)"gui.xaero_confirm", (Object[])new Object[0])){

                @Override
                protected void onPress() {
                    GuiSettings.this.confirm();
                }
            });
            this.buttonList.add(new GuiActionButton(this.width / 2 + 5, this.height / 6 + 168, 100, 20, I18n.format((String)"gui.xaero_back", (Object[])new Object[0])){

                @Override
                protected void onPress() {
                    GuiSettings.this.goBack();
                }
            });
        } else {
            this.buttonList.add(new GuiActionButton(this.width / 2 - 100, this.height / 6 + 168, 200, 20, I18n.format((String)"gui.xaero_back", (Object[])new Object[0])){

                @Override
                protected void onPress() {
                    GuiSettings.this.goBack();
                }
            });
        }
        int verticalOffset = this.getVerticalOffset();
        if (this.entries != null) {
            ArrayList<KeySortableByOther<ISettingEntry>> sortingList = new ArrayList<KeySortableByOther<ISettingEntry>>();
            String comparisonFilter = this.entryFilter.toLowerCase();
            for (int i = 0; i < this.entries.length; ++i) {
                int positionInEntryString;
                ISettingEntry entry = this.entries[i];
                String entrySearchString = entry.getStringForSearch().toLowerCase();
                if (entrySearchString == null || (positionInEntryString = entrySearchString.indexOf(comparisonFilter)) == -1) continue;
                KeySortableByOther<ISettingEntry> sortableEntry = new KeySortableByOther<ISettingEntry>(entry, Integer.valueOf(positionInEntryString));
                sortingList.add(sortableEntry);
            }
            List filteredEntries = sortingList.stream().sorted().map(new Function<KeySortableByOther<ISettingEntry>, ISettingEntry>(){

                @Override
                public ISettingEntry apply(KeySortableByOther<ISettingEntry> sortingKey) {
                    return sortingKey.getKey();
                }
            }).collect(Collectors.toList());
            if (!filteredEntries.isEmpty()) {
                this.foundSomething = true;
                this.maxPage = (int)Math.ceil((double)filteredEntries.size() / (double)this.entriesPerPage) - 1;
                if (this.page > this.maxPage) {
                    this.page = this.maxPage;
                }
                int firstEntry = this.entriesPerPage * this.page;
                int entryCount = Math.min(filteredEntries.size() - firstEntry, this.entriesPerPage);
                for (int i = 0; i < entryCount; ++i) {
                    ISettingEntry entry = (ISettingEntry)filteredEntries.get(firstEntry + i);
                    GuiButton optionWidget = entry.createWidget(this.width / 2 - 205 + i % 2 * 210, this.height / 7 + 5 + verticalOffset + 24 * (i >> 1), 200, this.width);
                    this.addButton(optionWidget);
                }
            } else {
                this.foundSomething = false;
                this.page = 0;
                this.maxPage = 0;
            }
        }
        this.screenTitle = this.screenTitle.createCopy().appendText(" (" + (this.page + 1) + "/" + (this.maxPage + 1) + ")");
        this.nextButton = new MyTinyButton(this.width / 2 + 131, this.height / 7 + 149 + verticalOffset, I18n.format((String)"gui.xaero_next", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                GuiSettings.this.onNextButton();
            }
        };
        this.prevButton = new MyTinyButton(this.width / 2 - 205, this.height / 7 + 149 + verticalOffset, I18n.format((String)"gui.xaero_previous", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                GuiSettings.this.onPrevButton();
            }
        };
        if (this.maxPage > 0) {
            this.addButton(this.nextButton);
            this.addButton(this.prevButton);
            this.nextButton.enabled = this.page < this.maxPage;
            this.prevButton.enabled = this.page > 0;
        }
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().initialize(this, this.width, this.height);
        boolean shouldFocusSearch = this.shouldRefocusSearch;
        this.shouldRefocusSearch = false;
        if (this.canSearch && this.entries != null) {
            int cursorPos = 0;
            if (shouldFocusSearch) {
                cursorPos = this.searchField.getCursorPosition();
            }
            this.searchField = new GuiTextField(0, this.fontRenderer, this.width / 2 - 100, this.height / 7 + 5 + verticalOffset - 24, 200, 20);
            this.searchField.setText(this.entryFilter);
            this.textFields.add(this.searchField);
            if (shouldFocusSearch) {
                this.setFocusedTextField(this.searchField);
                this.searchField.setCursorPosition(cursorPos);
                this.searchField.setSelectionPos(cursorPos);
            }
        } else {
            this.searchField = null;
        }
    }

    protected void confirm() {
        this.onExit(this.escape);
    }

    protected int getVerticalOffset() {
        return this.canSearch ? 24 : 0;
    }

    @Override
    protected void actionPerformed(GuiButton par1GuiButton) throws IOException {
        super.actionPerformed(par1GuiButton);
        this.buttonClicked = true;
        if (par1GuiButton.enabled) {
            int var2 = this.mc.gameSettings.guiScale;
            if (par1GuiButton instanceof GuiWidgetButton) {
                XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().handleButton(this, (GuiWidgetButton)par1GuiButton);
            }
            if (this.mc.gameSettings.guiScale != var2) {
                ScaledResolution var3 = new ScaledResolution(this.mc);
                int var4 = var3.getScaledWidth();
                int var5 = var3.getScaledHeight();
                this.setWorldAndResolution(this.mc, var4, var5);
            }
        }
    }

    @Override
    protected void renderPreDropdown(int mouseX, int mouseY, float partial) {
        super.renderPreDropdown(mouseX, mouseY, partial);
        if (this.searchField != null && !this.foundSomething && this.entries != null) {
            this.drawCenteredString(this.mc.fontRenderer, I18n.format((String)"gui.xaero_settings_not_found", (Object[])new Object[0]), this.width / 2, this.height / 7 + 34, 0xFFFFFF);
        }
    }

    @Override
    public void drawScreen(int par1, int par2, float par3) {
        this.drawDefaultBackground();
        int verticalOffset = this.getVerticalOffset();
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().render(this, this.width, this.height, par1, par2, this.guiScaleFactor);
        this.drawCenteredString(this.fontRenderer, this.screenTitle.getFormattedText(), this.width / 2, this.height / 7 + 29 - 42, 0xFFFFFF);
        if (this.searchField != null && !this.searchField.isFocused() && this.searchField.getText().isEmpty()) {
            GuiUtils.setFieldText(this.searchField, I18n.format((String)"gui.xaero_settings_search_placeholder", (Object[])new Object[0]), -11184811);
            this.searchField.setCursorPosition(0);
        }
        super.drawScreen(par1, par2, par3);
        if (this.searchField != null && !this.searchField.isFocused()) {
            GuiUtils.setFieldText(this.searchField, this.entryFilter);
        }
        if (this.openDropdown == null) {
            this.renderTooltips(par1, par2, par3);
        }
    }

    @Override
    public void addButtonVisible(GuiButton button) {
        this.addButton(button);
    }

    @Override
    public <S extends GuiScreen> S getScreen() {
        return (S)this;
    }

    @Override
    public void onExit(GuiScreen screen) {
        super.onExit(screen);
    }

    @Override
    public void keyTyped(char par1, int par2) throws IOException {
        super.keyTyped(par1, par2);
        if (this.searchField != null) {
            this.updateSearch();
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().handleClick(this, this.width, this.height, mouseX, mouseY, this.guiScaleFactor);
        this.buttonClicked = false;
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (!this.buttonClicked) {
            // empty if block
        }
    }

    protected void onNextButton() {
        ++this.page;
        this.setWorldAndResolution(this.mc, this.width, this.height);
    }

    protected void onPrevButton() {
        --this.page;
        this.setWorldAndResolution(this.mc, this.width, this.height);
    }

    public ISettingEntry[] getEntriesCopy() {
        if (this.entries == null) {
            return null;
        }
        ISettingEntry[] result = new ISettingEntry[this.entries.length];
        System.arraycopy(this.entries, 0, result, 0, this.entries.length);
        return result;
    }

    private void updateSearch() {
        String newValue;
        if (this.searchField.isFocused() && !Objects.equal((Object)this.entryFilter, (Object)(newValue = this.searchField.getText()))) {
            this.entryFilter = this.searchField.getText();
            this.shouldRefocusSearch = true;
            this.page = 0;
            this.setWorldAndResolution(this.mc, this.width, this.height);
        }
    }
}

