/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui;

import java.awt.Desktop;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import org.apache.commons.codec.binary.Hex;
import org.lwjgl.input.Mouse;
import xaero.lib.XaeroLib;
import xaero.lib.client.gui.widget.GuiActionButton;
import xaero.lib.client.gui.widget.online.GuiWidgetButton;
import xaero.lib.client.gui.widget.online.WidgetScreen;
import xaero.lib.patreon.Patreon;
import xaero.lib.patreon.PatreonMod;

public class GuiUpdateAll
extends GuiYesNo
implements WidgetScreen {
    private int guiScaleFactor;

    public GuiUpdateAll() {
        super(null, "These mods are out-of-date: " + GuiUpdateAll.modListToNames(Patreon.getOutdatedMods()), Patreon.getHasAutoUpdates() ? "Would you like to automatically update them?" : "Would you like to update them (open the mod pages)?", 0);
        Patreon.setNotificationDisplayed(true);
    }

    private static String modListToNames(List<Object> list) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(((PatreonMod)list.get((int)i)).modName);
        }
        return builder.toString();
    }

    public void initGui() {
        super.initGui();
        ScaledResolution var3 = new ScaledResolution(this.mc);
        this.guiScaleFactor = var3.getScaleFactor();
        if (Patreon.getHasAutoUpdates()) {
            this.buttonList.add(new GuiActionButton(this.width / 2 - 100, this.height / 6 + 120, 200, 20, I18n.format((String)"Changelogs", (Object[])new Object[0])){

                @Override
                protected void onPress() {
                    for (int i = 0; i < Patreon.getOutdatedMods().size(); ++i) {
                        PatreonMod mod = (PatreonMod)Patreon.getOutdatedMods().get(i);
                        try {
                            Desktop d = Desktop.getDesktop();
                            d.browse(new URI(mod.changelogLink));
                            continue;
                        }
                        catch (URISyntaxException e) {
                            XaeroLib.LOGGER.error("suppressed exception", (Throwable)e);
                            continue;
                        }
                        catch (IOException e) {
                            XaeroLib.LOGGER.error("suppressed exception", (Throwable)e);
                        }
                    }
                }
            });
        }
        this.buttonList.add(new GuiActionButton(this.width / 2 - 100, this.height / 6 + 144, 200, 20, I18n.format((String)"Don't show again for these updates", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                for (int i = 0; i < Patreon.getOutdatedMods().size(); ++i) {
                    PatreonMod mod = (PatreonMod)Patreon.getOutdatedMods().get(i);
                    if (mod.onVersionIgnore == null) continue;
                    mod.onVersionIgnore.run();
                }
                GuiUpdateAll.this.mc.displayGuiScreen(null);
            }
        });
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().initialize(this, this.width, this.height);
    }

    protected void actionPerformed(GuiButton button) throws IOException {
        switch (button.id) {
            case 0: {
                boolean shouldExit = false;
                if (Patreon.getHasAutoUpdates()) {
                    for (GuiButton b : this.buttonList) {
                        b.enabled = false;
                    }
                    shouldExit = this.autoUpdate();
                } else {
                    shouldExit = true;
                    for (int i = 0; i < Patreon.getOutdatedMods().size(); ++i) {
                        PatreonMod m = (PatreonMod)Patreon.getOutdatedMods().get(i);
                        try {
                            Desktop d = Desktop.getDesktop();
                            d.browse(new URI(m.changelogLink));
                            if (m.modJar == null) continue;
                            d.open(m.modJar.getParentFile());
                            continue;
                        }
                        catch (Exception e) {
                            XaeroLib.LOGGER.error("suppressed exception", (Throwable)e);
                            shouldExit = false;
                        }
                    }
                }
                if (shouldExit) {
                    Minecraft.getMinecraft().shutdown();
                    break;
                }
                Minecraft.getMinecraft().displayGuiScreen(null);
                break;
            }
            case 1: {
                this.mc.displayGuiScreen(null);
            }
        }
        if (button instanceof GuiWidgetButton) {
            XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().handleButton(this, (GuiWidgetButton)button);
        }
    }

    private static void download(BufferedOutputStream output, InputStream input, boolean closeInput) throws IOException {
        int read;
        byte[] buffer = new byte[256];
        while ((read = input.read(buffer, 0, buffer.length)) >= 0) {
            output.write(buffer, 0, read);
        }
        output.flush();
        if (closeInput) {
            input.close();
        }
        output.close();
    }

    public boolean autoUpdate() {
        try {
            MessageDigest digestMD5;
            try {
                digestMD5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e1) {
                XaeroLib.LOGGER.info("No algorithm for MD5.");
                return false;
            }
            PatreonMod autoupdater = (PatreonMod)Patreon.getMods().get("autoupdater30");
            String jarLink = autoupdater.changelogLink;
            String jarMD5 = autoupdater.latestVersionLayout;
            URL url = new URL(jarLink);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(900);
            conn.setConnectTimeout(900);
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11");
            if (conn.getContentLengthLong() > 0x200000L) {
                throw new IOException("Input too long to trust!");
            }
            InputStream input = conn.getInputStream();
            input = new BufferedInputStream(input);
            DigestInputStream digestInput = new DigestInputStream(input, digestMD5);
            BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(Minecraft.getMinecraft().mcDataDir.toPath().resolve("xaero_autoupdater.jar").toFile()));
            GuiUpdateAll.download(output, digestInput, true);
            byte[] digest = digestMD5.digest();
            String fileMD5 = Hex.encodeHexString((byte[])digest);
            if (!jarMD5.equals(fileMD5)) {
                XaeroLib.LOGGER.info("Invalid autoupdater MD5: " + fileMD5);
                return false;
            }
            ArrayList<String> command = new ArrayList<String>();
            Path javaPath = new File(System.getProperty("java.home")).toPath().resolve("bin").resolve("java");
            command.add(javaPath.toString());
            command.add("-jar");
            command.add("./xaero_autoupdater.jar");
            command.add("6");
            command.add(Patreon.getUpdateLocation());
            for (int i = 0; i < Patreon.getOutdatedMods().size(); ++i) {
                PatreonMod m = (PatreonMod)Patreon.getOutdatedMods().get(i);
                if (m.modJar == null) continue;
                int canonicalPathAttempts = 10;
                String jarPath = null;
                while (canonicalPathAttempts-- > 0) {
                    try {
                        jarPath = m.modJar.getCanonicalPath();
                        break;
                    }
                    catch (IOException ioe) {
                        XaeroLib.LOGGER.info("IO exception fetching the canonical path to the mod jar!");
                        if (canonicalPathAttempts == 0) {
                            throw ioe;
                        }
                        XaeroLib.LOGGER.error("suppressed exception", (Throwable)ioe);
                        XaeroLib.LOGGER.info("Retrying... (" + canonicalPathAttempts + ")");
                        try {
                            Thread.sleep(25L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                command.add(jarPath);
                command.add(m.latestVersionLayout);
                command.add(m.currentVersion.split("_")[1]);
                command.add(m.latestVersion);
                command.add(m.currentVersion.split("_")[0]);
                command.add(m.md5 == null ? "null" : m.md5);
            }
            XaeroLib.LOGGER.info(String.join((CharSequence)", ", command));
            Runtime.getRuntime().exec(command.toArray(new String[0]));
        }
        catch (IOException e) {
            XaeroLib.LOGGER.error("suppressed exception", (Throwable)e);
            return false;
        }
        return true;
    }

    public void drawDefaultBackground() {
        super.drawDefaultBackground();
        int mouseX = (int)((double)Mouse.getX() * (double)this.width / (double)this.mc.displayWidth);
        int mouseY = (int)((double)Mouse.getY() * (double)this.height / (double)this.mc.displayHeight);
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().render(this, this.width, this.height, mouseX, mouseY, this.guiScaleFactor);
    }

    public void drawScreen(int p_render_1_, int p_render_2_, float p_render_3_) {
        super.drawScreen(p_render_1_, p_render_2_, p_render_3_);
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().renderTooltips((GuiScreen)this, this.width, this.height, p_render_1_, p_render_2_, this.guiScaleFactor);
    }

    @Override
    public void addButtonVisible(GuiButton button) {
        this.addButton(button);
    }

    @Override
    public <S extends GuiScreen> S getScreen() {
        return (S)this;
    }

    public void mouseClicked(int p_mouseClicked_1_, int p_mouseClicked_3_, int p_mouseClicked_5_) throws IOException {
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().handleClick((GuiScreen)this, this.width, this.height, p_mouseClicked_1_, p_mouseClicked_3_, this.guiScaleFactor);
        super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }
}

