/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import xaero.lib.XaeroLib;
import xaero.lib.client.gui.IScreenBase;
import xaero.lib.client.gui.widget.GuiActionButton;
import xaero.lib.client.gui.widget.ITooltipHaver;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.XaeroSliderWidget;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;

public class ScreenBase
extends GuiScreen
implements IScreenBase {
    public GuiScreen parent;
    public GuiScreen escape;
    protected boolean canSkipWorldRender;
    protected int guiScaleFactor;
    protected DropDownWidget openDropdown;
    private List<DropDownWidget> dropdowns;
    protected GuiTextField focusedTextField;
    protected final List<GuiTextField> textFields;
    protected boolean handledMouseInput;
    protected boolean handledKeyboardInput;
    protected boolean shouldRefresh;
    protected ITextComponent title;

    protected ScreenBase(GuiScreen parent, GuiScreen escape, ITextComponent titleIn) {
        this.parent = parent;
        this.escape = escape;
        this.title = titleIn;
        this.dropdowns = new ArrayList<DropDownWidget>();
        this.textFields = new ArrayList<GuiTextField>();
    }

    public void onExit(GuiScreen screen) {
        this.mc.displayGuiScreen(screen);
    }

    public void goBack() {
        this.onExit(this.parent);
    }

    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.onClose();
            if (this.mc.currentScreen == null) {
                this.mc.setIngameFocus();
            }
            this.handledKeyboardInput = true;
            return;
        }
        if (this.focusedTextField != null) {
            this.handledKeyboardInput = this.focusedTextField.textboxKeyTyped(typedChar, keyCode);
        }
    }

    public void onClose() {
        this.onExit(this.escape);
    }

    protected void actionPerformed(GuiButton button) throws IOException {
        this.handledMouseInput = true;
        if (button instanceof GuiActionButton) {
            ((GuiActionButton)button).press();
            return;
        }
        super.actionPerformed(button);
    }

    public void renderEscapeScreen(int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        if (this.escape != null) {
            this.escape.drawScreen(p_230430_2_, p_230430_3_, p_230430_4_);
            GlStateManager.clear((int)256);
        }
    }

    public void drawDefaultBackground() {
        this.handleRefresh();
        super.drawDefaultBackground();
    }

    public void drawScreen(int mouseX, int mouseY, float partial) {
        this.handleRefresh();
        super.drawScreen(mouseX, mouseY, partial);
        this.textFields.forEach(new Consumer<GuiTextField>(){

            @Override
            public void accept(GuiTextField field) {
                field.drawTextBox();
            }
        });
        this.renderPreDropdown(mouseX, mouseY, partial);
        for (DropDownWidget dropdown : this.dropdowns) {
            dropdown.render(mouseX, mouseY, this.height, true);
        }
        if (this.openDropdown != null) {
            GlStateManager.pushMatrix();
            GlStateManager.translate((float)0.0f, (float)0.0f, (float)2.0f);
            this.openDropdown.render(mouseX, mouseY, this.height, false);
            GlStateManager.popMatrix();
        }
    }

    protected void renderPreDropdown(int mouseX, int mouseY, float partial) {
    }

    public void initGui() {
        super.initGui();
        ScaledResolution var3 = new ScaledResolution(this.mc);
        this.guiScaleFactor = var3.getScaleFactor();
        this.dropdowns.clear();
        this.openDropdown = null;
        this.textFields.clear();
        this.focusedTextField = null;
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void onGuiClosed() {
        super.onGuiClosed();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void setWorldAndResolution(Minecraft p_231158_1_, int p_231158_2_, int p_231158_3_) {
        super.setWorldAndResolution(p_231158_1_, p_231158_2_, p_231158_3_);
        if (this.escape != null) {
            this.escape.setWorldAndResolution(p_231158_1_, p_231158_2_, p_231158_3_);
        }
    }

    public void setFocusedTextField(GuiTextField textField) {
        if (this.focusedTextField != null) {
            this.focusedTextField.setFocused(false);
        }
        this.focusedTextField = textField;
        if (textField != null) {
            textField.setFocused(true);
        }
    }

    protected void mouseClicked(int mouseX, int mouseY, int button) throws IOException {
        if (this.openDropdown != null) {
            if (!this.openDropdown.onDropDown(mouseX, mouseY, this.height)) {
                this.openDropdown.setClosed(true);
                this.openDropdown = null;
            } else {
                if (button == 0) {
                    this.openDropdown.mousePressed(this.mc, mouseX, mouseY);
                }
                this.handledMouseInput = true;
                return;
            }
        }
        super.mouseClicked(mouseX, mouseY, button);
        if (this.handledMouseInput) {
            return;
        }
        for (GuiTextField textField : this.textFields) {
            if (!textField.mouseClicked(mouseX, mouseY, button)) continue;
            this.setFocusedTextField(textField);
            this.handledMouseInput = true;
            return;
        }
        this.setFocusedTextField(null);
    }

    public void handleMouseInput() throws IOException {
        this.handledMouseInput = false;
        super.handleMouseInput();
        if (this.handledMouseInput) {
            return;
        }
        int wheel = Mouse.getEventDWheel() / 120;
        if (wheel != 0) {
            ScaledResolution var3 = new ScaledResolution(this.mc);
            int mouseXScaled = Mouse.getX() / var3.getScaleFactor();
            int mouseYScaled = var3.getScaledHeight() - 1 - Mouse.getY() / var3.getScaleFactor();
            if (this.openDropdown != null && this.openDropdown.onDropDown(mouseXScaled, mouseYScaled, this.height)) {
                this.openDropdown.mouseScrolled(wheel, mouseXScaled, mouseYScaled, this.height);
            }
        }
    }

    public void handleKeyboardInput() throws IOException {
        this.handledKeyboardInput = false;
        super.handleKeyboardInput();
    }

    protected void mouseReleased(int mouseX, int mouseY, int button) {
        if (this.openDropdown != null && button == 0) {
            this.openDropdown.mouseReleased(mouseX, mouseY);
        }
        super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean shouldSkipWorldRender() {
        return this.canSkipWorldRender && this.escape instanceof IScreenBase && ((IScreenBase)this.escape).shouldSkipWorldRender();
    }

    protected boolean renderTooltips(int par1, int par2, float par3) {
        GlStateManager.pushMatrix();
        GlStateManager.translate((double)0.0, (double)0.0, (double)2.1);
        boolean result = XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().renderTooltips(this, this.width, this.height, par1, par2, this.guiScaleFactor);
        boolean mousePressed = Mouse.isButtonDown((int)0);
        for (int k = 0; k < this.buttonList.size(); ++k) {
            Tooltip tooltip;
            GuiButton b = (GuiButton)this.buttonList.get(k);
            if (!(b instanceof ITooltipHaver) || b instanceof XaeroSliderWidget && mousePressed) continue;
            ITooltipHaver optionWidget = (ITooltipHaver)b;
            if (par1 < b.x || par2 < b.y || par1 >= b.x + b.width || par2 >= b.y + b.height || optionWidget.getXaero_tooltip() == null || (tooltip = optionWidget.getXaero_tooltip().get()) == null) continue;
            tooltip.drawBox(par1, par2, this.width, this.height);
            result = true;
            break;
        }
        GlStateManager.popMatrix();
        return result;
    }

    public void updateScreen() {
        super.updateScreen();
        for (GuiTextField textField : this.textFields) {
            textField.updateCursorCounter();
        }
    }

    @Override
    public void onDropdownOpen(DropDownWidget menu) {
        if (this.openDropdown != null && this.openDropdown != menu) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = menu;
    }

    @Override
    public void onDropdownClosed(DropDownWidget menu) {
        if (menu != this.openDropdown && this.openDropdown != null) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = null;
    }

    protected void addWidget(DropDownWidget guiEventListener) {
        this.dropdowns.add(guiEventListener);
        this.buttonList.add(guiEventListener);
    }

    public void replaceWidget(GuiButton current, GuiButton replacement) {
        int dropdownIndex;
        int buttonIndex = this.buttonList.indexOf(current);
        if (buttonIndex != -1) {
            this.buttonList.set(buttonIndex, replacement);
        }
        if ((dropdownIndex = this.dropdowns.indexOf(current)) != -1) {
            this.dropdowns.set(dropdownIndex, (DropDownWidget)replacement);
        }
    }

    public void removeWidget(GuiButton current) {
        this.buttonList.remove(current);
        this.dropdowns.remove(current);
    }

    @Override
    public GuiScreen getEscape() {
        return this.escape;
    }

    public static GuiScreen tryToGetEscape(GuiScreen screen) {
        if (screen instanceof IScreenBase) {
            return ((IScreenBase)screen).getEscape();
        }
        return null;
    }

    public void refresh() {
        this.shouldRefresh = true;
    }

    protected final void handleRefresh() {
        if (!this.shouldRefresh) {
            return;
        }
        this.shouldRefresh = false;
        this.setWorldAndResolution(this.mc, this.width, this.height);
    }

    public int getIndex(GuiButton child) {
        for (int i = 0; i < this.buttonList.size(); ++i) {
            if (this.buttonList.get(i) != child) continue;
            return i;
        }
        return -1;
    }

    public boolean canSkipWorldRender() {
        return this.canSkipWorldRender;
    }
}

