/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.config;

import java.io.IOException;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.config.ConfigProfileDropdownContext;
import xaero.lib.client.gui.config.context.IEditConfigScreenContext;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.client.gui.widget.dropdown.IDropDownWidgetCallback;
import xaero.lib.common.config.channel.ConfigChannel;
import xaero.lib.common.config.option.BuiltInProfiledConfigOptions;
import xaero.lib.common.config.util.ConfigUtils;

public final class ConfigProfileCreationScreen
extends ScreenBase {
    private static final ITextComponent PROFILE_TO_COPY_COMPONENT = new TextComponentTranslation("gui.xaero_config_profile_to_copy", new Object[0]);
    private DropDownWidget profileToCopyDropdown;
    private GuiTextField editBox;
    private GuiButton confirmButton;
    private String currentValue;
    private final IEditConfigScreenContext context;
    private final ConfigChannel channel;
    private final Runnable onConfirm;
    private ConfigProfileDropdownContext dropdownContext;
    private String selectedProfileToCopy;

    protected ConfigProfileCreationScreen(GuiScreen parent, IEditConfigScreenContext context, ConfigChannel channel, Runnable onConfirm) {
        super(parent, parent, (ITextComponent)new TextComponentTranslation("gui.xaero_config_profile_creation_screen", new Object[0]));
        this.context = context;
        this.channel = channel;
        this.onConfirm = onConfirm;
        this.currentValue = "";
        this.selectedProfileToCopy = context.getSelectedProfileId(channel);
    }

    @Override
    public void initGui() {
        super.initGui();
        this.dropdownContext = new ConfigProfileDropdownContext(this.context, this.channel, null, this.selectedProfileToCopy, false);
        this.profileToCopyDropdown = DropDownWidget.Builder.begin().setX(this.width / 2 - 100).setY(this.height / 7 + 15).setW(200).setCallback(new IDropDownWidgetCallback(){

            @Override
            public boolean onSelected(DropDownWidget menu, int selected) {
                return ConfigProfileCreationScreen.this.onDropdownSelection(menu, selected);
            }
        }).setOptions(this.dropdownContext.getOptions()).setSelected(this.dropdownContext.getInitialSelection()).setContainer(this).build();
        this.addWidget(this.profileToCopyDropdown);
        this.editBox = new GuiTextField(0, this.fontRenderer, this.width / 2 - 100, this.height / 7 + 55, 200, 20);
        this.textFields.add(this.editBox);
        this.editBox.setMaxStringLength(50);
        this.setFocusedTextField(this.editBox);
        this.editBox.setText(this.currentValue);
        this.editBox.setGuiResponder(new GuiPageButtonList.GuiResponder(){

            public void setEntryValue(int id, String value) {
                ConfigProfileCreationScreen.this.onChange(value);
            }

            public void setEntryValue(int id, float value) {
            }

            public void setEntryValue(int id, boolean value) {
            }
        });
        this.confirmButton = new MySmallButton(200, this.width / 2 - 155, this.height / 6 + 168, (ITextComponent)new TextComponentTranslation("gui.xaero_confirm", new Object[0])){

            @Override
            protected void onPress() {
                ConfigProfileCreationScreen.this.confirm();
            }
        };
        this.buttonList.add(this.confirmButton);
        this.buttonList.add(new MySmallButton(201, this.width / 2 + 5, this.height / 6 + 168, (ITextComponent)new TextComponentTranslation("gui.xaero_cancel", new Object[0])){

            @Override
            protected void onPress() {
                ConfigProfileCreationScreen.this.goBack();
            }
        });
        this.updateConfirmButton();
    }

    private boolean onDropdownSelection(DropDownWidget menu, int selected) {
        if (!this.context.getSyncStatus(this.channel)) {
            return false;
        }
        this.selectedProfileToCopy = this.dropdownContext.getProfiles()[selected].getId();
        return true;
    }

    private void onChange(String s) {
        this.currentValue = s;
        this.updateConfirmButton();
    }

    private boolean canConfirm() {
        return !this.editBox.getText().isEmpty() && BuiltInProfiledConfigOptions.PROFILE_NAME.isValidValue(this.editBox.getText());
    }

    private void updateConfirmButton() {
        this.confirmButton.enabled = this.canConfirm();
    }

    public void confirm() {
        if (!this.canConfirm()) {
            return;
        }
        String autoId = ConfigUtils.getAutoProfileIdForName(new Predicate<String>(){

            @Override
            public boolean test(String s) {
                return ConfigProfileCreationScreen.this.profileExists(s);
            }
        }, this.editBox.getText());
        this.createProfile(autoId, this.editBox.getText(), this.selectedProfileToCopy);
        this.context.setCurrentProfile(autoId, this.channel);
        this.onConfirm.run();
        this.goBack();
    }

    private boolean profileExists(String id) {
        return this.context.profileExists(id, this.channel);
    }

    private void createProfile(String id, String name, String profileToCopy) {
        this.context.createProfile(id, name, this.channel, profileToCopy);
    }

    @Override
    protected void keyTyped(char typedChar, int keyCode) throws IOException {
        super.keyTyped(typedChar, keyCode);
        if ((keyCode == 28 || keyCode == 156) && this.canConfirm()) {
            this.actionPerformed(this.confirmButton);
        }
    }

    @Override
    public void drawDefaultBackground() {
        super.drawDefaultBackground();
        this.drawCenteredString(this.fontRenderer, PROFILE_TO_COPY_COMPONENT.getFormattedText(), this.width / 2, this.height / 7, -1);
        this.drawCenteredString(this.fontRenderer, this.title.getFormattedText(), this.width / 2, this.height / 7 + 40, -1);
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partial) {
        this.drawDefaultBackground();
        super.drawScreen(mouseX, mouseY, partial);
    }
}

