/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.config;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.config.EditConfigScreen;
import xaero.lib.client.gui.widget.GuiActionButton;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.option.ConfigOption;

public class EditStringConfigOptionScreen<T>
extends ScreenBase {
    private GuiTextField editBox;
    private GuiButton confirmButton;
    private final Config config;
    private final Config enforcedConfig;
    private final ConfigOption<T> configOption;
    private final boolean allowEmpty;
    private final boolean emptyMeansNull;
    private final Runnable postConfirmAction;
    private boolean valid;
    private String currentValue;
    private ITextComponent enforcedValueLabel;
    protected boolean shouldRenderEscapeScreen;

    public EditStringConfigOptionScreen(GuiScreen parent, GuiScreen escape, Config config, Config enforcedConfig, ConfigOption<T> configOption, boolean allowEmpty, boolean emptyMeansNull, Runnable postConfirmAction) {
        super(parent, escape, configOption.getDisplayName());
        this.config = config;
        this.enforcedConfig = enforcedConfig;
        this.configOption = configOption;
        this.allowEmpty = allowEmpty;
        this.emptyMeansNull = emptyMeansNull;
        this.postConfirmAction = postConfirmAction;
        T value = config.get(configOption);
        this.currentValue = value == null ? "" : configOption.getValueType().getIoCodec().encode(value, null, configOption);
        this.shouldRenderEscapeScreen = false;
        this.canSkipWorldRender = false;
        if (parent instanceof EditConfigScreen) {
            EditConfigScreen configScreen = (EditConfigScreen)parent;
            this.shouldRenderEscapeScreen = configScreen.shouldRenderEscapeScreen;
            this.canSkipWorldRender = configScreen.canSkipWorldRender();
        }
    }

    @Override
    public void initGui() {
        super.initGui();
        Object enforcedValue = this.enforcedConfig == null ? null : (Object)this.enforcedConfig.get(this.configOption);
        this.enforcedValueLabel = enforcedValue == null ? null : new TextComponentTranslation("gui.xaero_config_value_enforced_string_edit", new Object[]{this.configOption.getValueType().getIoCodec().encode(enforcedValue, null, this.configOption)}).setStyle(new Style().setColor(TextFormatting.YELLOW));
        this.editBox = new GuiTextField(0, this.fontRenderer, this.width / 2 - 100, this.height / 7 + 29 - 2, 200, 20);
        this.editBox.setMaxStringLength(this.configOption.getValueType().getIoCodec().getMaxStringLength());
        this.editBox.setText(this.currentValue);
        this.editBox.setGuiResponder(new GuiPageButtonList.GuiResponder(){

            public void setEntryValue(int id, boolean value) {
            }

            public void setEntryValue(int id, float value) {
            }

            public void setEntryValue(int id, String value) {
                EditStringConfigOptionScreen.this.onChange(value);
            }
        });
        this.textFields.add(this.editBox);
        this.setFocusedTextField(this.editBox);
        this.confirmButton = new GuiActionButton(this.width / 2 - 105, this.height / 7 + 29 + 48, 100, 20, I18n.format((String)"gui.xaero_confirm", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                EditStringConfigOptionScreen.this.confirm();
            }
        };
        this.buttonList.add(this.confirmButton);
        this.buttonList.add(new GuiActionButton(this.width / 2 + 5, this.height / 7 + 29 + 48, 100, 20, I18n.format((String)"gui.xaero_cancel", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                EditStringConfigOptionScreen.this.goBack();
            }
        });
        this.valid = true;
        this.updateConfirmButton();
    }

    private void onChange(String s) {
        this.currentValue = s;
        this.valid = true;
        if (this.editBox.getText().isEmpty()) {
            this.valid = this.allowEmpty;
            this.updateConfirmButton();
            return;
        }
        try {
            T value = this.configOption.getValueType().getIoCodec().decode(s, null, this.configOption);
            this.valid = this.configOption.isValidValue(value);
        }
        catch (Throwable t) {
            this.valid = false;
        }
        this.updateConfirmButton();
    }

    private boolean canConfirm() {
        return this.valid;
    }

    private void updateConfirmButton() {
        this.confirmButton.enabled = this.canConfirm();
    }

    public void confirm() {
        Object value;
        if (!this.canConfirm()) {
            return;
        }
        Object t = value = this.editBox.getText().isEmpty() && this.emptyMeansNull ? null : (Object)this.configOption.getValueType().getIoCodec().decode(this.editBox.getText(), null, this.configOption);
        if (value != null && !this.configOption.isValidValue(value)) {
            return;
        }
        this.config.set(this.configOption, value);
        this.postConfirmAction.run();
        this.goBack();
    }

    @Override
    protected void keyTyped(char character, int keyCode) throws IOException {
        if ((keyCode == 28 || keyCode == 156) && this.canConfirm()) {
            this.actionPerformed(this.confirmButton);
        }
        super.keyTyped(character, keyCode);
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partial) {
        if (this.shouldRenderEscapeScreen) {
            this.renderEscapeScreen(mouseX, mouseY, partial);
        }
        this.drawDefaultBackground();
        super.drawScreen(mouseX, mouseY, partial);
        if (this.enforcedValueLabel != null) {
            this.drawCenteredString(this.fontRenderer, this.enforcedValueLabel.getFormattedText(), this.width / 2, this.height / 7 + 29 - 22, 0xFFFFFF);
        }
        this.drawCenteredString(this.fontRenderer, this.title.getFormattedText(), this.width / 2, this.height / 7 + 29 - 42, 0xFFFFFF);
    }

    @Override
    public void onClose() {
        this.onExit(this.parent);
    }
}

