/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.util.graphics;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class GuiGraphicsUtils {
    public static void blit(int x, int y, float u, float v, int w, int h) {
        GuiGraphicsUtils.blit(x, x + w, y, y + h, 0, w, h, u, v, 256, 256);
    }

    public static void blit(int x, int y, int z, float u, float v, int w, int h, int textureW, int textureH) {
        GuiGraphicsUtils.blit(x, x + w, y, y + h, z, w, h, u, v, textureW, textureH);
    }

    static void blit(int left, int right, int top, int bottom, int z, int uw, int vh, float u, float v, int textureW, int textureH) {
        GuiGraphicsUtils.innerBlit(left, right, top, bottom, z, (u + 0.0f) / (float)textureW, (u + (float)uw) / (float)textureW, (v + 0.0f) / (float)textureH, (v + (float)vh) / (float)textureH);
    }

    static void innerBlit(int left, int right, int top, int bottom, int z, float uLeft, float uRight, float vTop, float vBottom) {
        BufferBuilder bufferBuilder = Tessellator.getInstance().getBuffer();
        bufferBuilder.begin(7, DefaultVertexFormats.POSITION_TEX);
        bufferBuilder.pos((double)left, (double)top, (double)z).tex((double)uLeft, (double)vTop).endVertex();
        bufferBuilder.pos((double)left, (double)bottom, (double)z).tex((double)uLeft, (double)vBottom).endVertex();
        bufferBuilder.pos((double)right, (double)bottom, (double)z).tex((double)uRight, (double)vBottom).endVertex();
        bufferBuilder.pos((double)right, (double)top, (double)z).tex((double)uRight, (double)vTop).endVertex();
        Tessellator.getInstance().draw();
    }
}

