/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.widget;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.lib.common.gui.widget.TooltipInfo;
import xaero.lib.common.util.TextSplitter;

public class Tooltip
implements Supplier<Tooltip> {
    private static final int BOX_OFFSET_X = 12;
    private static final int BOX_OFFSET_Y = 10;
    private static final int START_WIDTH = 20;
    private static final int USUAL_WIDTH = 200;
    private ArrayList<ITextComponent> strings;
    private ITextComponent directText;
    private boolean directTextReady;
    private String language;
    private String fullCode;
    private Style codeStyle;
    private String plainText;
    private int boxWidth = 20;
    private int startWidth = 20;
    private static final int color = -939524096;
    private boolean customLines;
    private boolean flippedByDefault;
    private boolean autoLinebreak;

    public Tooltip(String code) {
        this(code, null);
    }

    public Tooltip(String code, Style codeStyle) {
        this(code, codeStyle, false);
    }

    public Tooltip(String code, Style codeStyle, boolean flippedByDefault) {
        this.fullCode = code;
        this.codeStyle = codeStyle;
        this.flippedByDefault = flippedByDefault;
        this.autoLinebreak = true;
    }

    public Tooltip(ITextComponent directText) {
        this(directText, false);
    }

    public Tooltip(ITextComponent directText, boolean flippedByDefault) {
        this.directText = directText;
        this.flippedByDefault = flippedByDefault;
        this.autoLinebreak = true;
    }

    public Tooltip(int size) {
        this.strings = new ArrayList();
        for (int i = 0; i < size; ++i) {
            this.strings.add((ITextComponent)new TextComponentString(""));
        }
        this.customLines = true;
    }

    public Tooltip(TooltipInfo info) {
        this(info.text, info.flippedByDefault);
        this.autoLinebreak = info.autoLineBreak;
    }

    public void setStartWidth(int startWidth) {
        this.startWidth = startWidth;
    }

    private String currentLanguage() {
        return Minecraft.getMinecraft().getLanguageManager().getCurrentLanguage().getLanguageCode();
    }

    public void createLines(ITextComponent text) {
        try {
            this.language = this.currentLanguage();
        }
        catch (NullPointerException e) {
            this.language = "en_us";
        }
        this.strings = new ArrayList();
        this.splitWords(this.strings, text);
    }

    public void splitWords(ArrayList<ITextComponent> dest, ITextComponent formattedText) {
        StringBuilder plainTextBuilder = new StringBuilder();
        this.boxWidth = 20 + TextSplitter.splitTextIntoLines(dest, this.startWidth - 20, (this.autoLinebreak ? 200 : Integer.MAX_VALUE) - 20, formattedText, plainTextBuilder);
        this.plainText = plainTextBuilder.toString().replaceAll("(\u00a7[0-9a-g])+", "");
    }

    public ITextComponent getLine(int line) {
        return this.strings.get(line);
    }

    private void ensure() {
        try {
            if (!(this.customLines || (this.fullCode != null || this.directTextReady) && this.language != null && this.language.equals(this.currentLanguage()))) {
                if (this.fullCode != null) {
                    this.createLines(new TextComponentTranslation(this.fullCode, new Object[0]).setStyle(this.codeStyle));
                } else {
                    this.createLines(this.directText);
                    this.directTextReady = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawBox(int x, int y, int width, int height) {
        int h;
        int overEdgeY;
        this.ensure();
        int drawX = x + 12;
        int drawY = y + 10;
        int overEdgeX = drawX + this.boxWidth - width;
        if (this.flippedByDefault || overEdgeX > 9) {
            drawX = x - 12 - this.boxWidth;
        } else if (overEdgeX > 0) {
            drawX -= overEdgeX;
        }
        if (drawX < 0) {
            drawX = 0;
        }
        if ((overEdgeY = drawY + (h = 5 + this.strings.size() * 10 + 5) - height) > h / 2) {
            drawY = y - 10 - h;
        } else if (overEdgeY > 0) {
            drawY -= overEdgeY;
        }
        if (drawY < 0) {
            drawY = 0;
        }
        Gui.drawRect((int)drawX, (int)drawY, (int)(drawX + this.boxWidth), (int)(drawY + h), (int)-939524096);
        for (int i = 0; i < this.strings.size(); ++i) {
            ITextComponent s = this.getLine(i);
            Minecraft.getMinecraft().fontRenderer.drawString(s.getFormattedText(), drawX + 10, drawY + 6 + 10 * i, 0xFFFFFF);
        }
    }

    public Tooltip withWidth(int boxWidth) {
        this.boxWidth = boxWidth;
        return this;
    }

    public void setAutoLinebreak(boolean autoLinebreak) {
        this.autoLinebreak = autoLinebreak;
    }

    public String getPlainText() {
        this.ensure();
        return this.plainText;
    }

    public String getFullCode() {
        return this.fullCode;
    }

    @Override
    public Tooltip get() {
        return this;
    }
}

