/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.widget;

import java.util.function.DoubleConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.input.Mouse;
import xaero.lib.client.gui.widget.IClickableWidget;
import xaero.lib.client.gui.widget.Tooltip;

public class XaeroSliderWidget
extends GuiButton
implements IClickableWidget {
    protected Supplier<Tooltip> tooltipSupplier;
    private final DoubleConsumer valueListener;
    private final Supplier<String> labelGetter;
    protected double value;
    protected int scaledScreenWidth;
    protected boolean dragging;

    public XaeroSliderWidget(int x, int y, int w, int h, String label, double value, DoubleConsumer valueListener, Supplier<String> labelGetter, int scaledScreenWidth) {
        super(0, x, y, w, h, label);
        this.valueListener = valueListener;
        this.labelGetter = labelGetter;
        this.value = value;
        this.scaledScreenWidth = scaledScreenWidth;
    }

    protected int getHoverState(boolean mouseOver) {
        return 0;
    }

    protected void mouseDragged(Minecraft mc, int mouseX, int mouseY) {
        if (this.visible) {
            if (this.dragging) {
                this.updateValue(mc, mouseX);
            }
            mc.getTextureManager().bindTexture(BUTTON_TEXTURES);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawTexturedModalRect(this.x + (int)(this.value * (double)(this.width - 8)), this.y, 0, 66, 4, 20);
            this.drawTexturedModalRect(this.x + (int)(this.value * (double)(this.width - 8)) + 4, this.y, 196, 66, 4, 20);
        }
    }

    public boolean mousePressed(Minecraft mc, int mouseX, int mouseY) {
        if (super.mousePressed(mc, mouseX, mouseY)) {
            this.updateValue(mc, mouseX);
            this.dragging = true;
            return true;
        }
        return false;
    }

    private void updateValue(Minecraft mc, int mouseX) {
        double actualMouseX = (double)Mouse.getX() / (double)mc.displayWidth * (double)this.scaledScreenWidth;
        double partialMouseX = actualMouseX - (double)((int)actualMouseX);
        double finalMouseX = (double)mouseX + partialMouseX;
        this.value = (finalMouseX - (double)(this.x + 4)) / (double)(this.width - 8);
        this.value = MathHelper.clamp((double)this.value, (double)0.0, (double)1.0);
        this.applyValue();
        this.updateMessage();
    }

    public void mouseReleased(int mouseX, int mouseY) {
        this.dragging = false;
    }

    protected void applyValue() {
        this.valueListener.accept(this.value);
    }

    protected void updateMessage() {
        this.displayString = this.labelGetter.get();
    }

    @Override
    public void setXaero_tooltip(Supplier<Tooltip> tooltip) {
        this.tooltipSupplier = tooltip;
    }

    @Override
    public Supplier<Tooltip> getXaero_tooltip() {
        return this.tooltipSupplier;
    }
}

