/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.config.option.value.sync.serialization;

import java.util.function.Function;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import xaero.lib.common.config.option.value.sync.serialization.ConfigValueSyncCodec;

public class BuiltInConfigValueSyncCodecs {
    public static final ConfigValueSyncCodec<Boolean, NBTTagByte> BOOLEAN = new ConfigValueSyncCodec<Boolean, NBTTagByte>(new Function<Boolean, NBTTagByte>(){

        @Override
        public NBTTagByte apply(Boolean b) {
            return new NBTTagByte((byte)(b != false ? 1 : 0));
        }
    }, new Function<NBTTagByte, Boolean>(){

        @Override
        public Boolean apply(NBTTagByte tag) {
            return tag.getByte() == 1;
        }
    });
    public static final ConfigValueSyncCodec<Integer, NBTTagInt> INTEGER = new ConfigValueSyncCodec<Integer, NBTTagInt>(new Function<Integer, NBTTagInt>(){

        @Override
        public NBTTagInt apply(Integer i) {
            return new NBTTagInt(i.intValue());
        }
    }, new Function<NBTTagInt, Integer>(){

        @Override
        public Integer apply(NBTTagInt tag) {
            return tag.getInt();
        }
    });
    public static final ConfigValueSyncCodec<Double, NBTTagDouble> DOUBLE = new ConfigValueSyncCodec<Double, NBTTagDouble>(new Function<Double, NBTTagDouble>(){

        @Override
        public NBTTagDouble apply(Double d) {
            return new NBTTagDouble(d.doubleValue());
        }
    }, new Function<NBTTagDouble, Double>(){

        @Override
        public Double apply(NBTTagDouble tag) {
            return tag.getDouble();
        }
    });
    public static final ConfigValueSyncCodec<String, NBTTagString> STRING = new ConfigValueSyncCodec<String, NBTTagString>(new Function<String, NBTTagString>(){

        @Override
        public NBTTagString apply(String s) {
            return new NBTTagString(s);
        }
    }, new Function<NBTTagString, String>(){

        @Override
        public String apply(NBTTagString tag) {
            return tag.getString();
        }
    });
    public static final ConfigValueSyncCodec<ResourceLocation, NBTTagString> RESOURCE_LOCATION = new ConfigValueSyncCodec<ResourceLocation, NBTTagString>(new Function<ResourceLocation, NBTTagString>(){

        @Override
        public NBTTagString apply(ResourceLocation rl) {
            return STRING.encode(rl.toString());
        }
    }, new Function<NBTTagString, ResourceLocation>(){

        @Override
        public ResourceLocation apply(NBTTagString tag) {
            return new ResourceLocation(STRING.decode(tag));
        }
    });
}

