/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.option.value.sync.serialization.ConfigValueSyncCodec;
import xaero.lib.common.packet.XaeroPacket;

public abstract class AbstractConfigPacket<P extends AbstractConfigPacket<P>>
extends XaeroPacket {
    private List<OptionEntry> entries;

    protected AbstractConfigPacket(List<OptionEntry> entries) {
        this.entries = entries;
    }

    protected AbstractConfigPacket() {
    }

    @Override
    public final void write(PacketBuffer buffer) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound optionsTag = new NBTTagCompound();
        for (OptionEntry entry : this.entries) {
            optionsTag.setTag(entry.optionId, entry.valueTag);
        }
        tag.setTag("o", (NBTBase)optionsTag);
        this.writeExtra(tag);
        buffer.writeCompoundTag(tag);
    }

    public Iterable<OptionEntry> getEntries() {
        return this.entries;
    }

    protected abstract void writeExtra(NBTTagCompound var1);

    public void readOptions(NBTTagCompound tag) {
        NBTTagCompound optionsTag = tag.getCompoundTag("o");
        ArrayList<OptionEntry> result = new ArrayList<OptionEntry>();
        for (String optionId : optionsTag.getKeySet()) {
            NBTBase valueTag = optionsTag.getTag(optionId);
            result.add(new OptionEntry(optionId, valueTag));
        }
        this.entries = result;
    }

    public static class OptionEntry {
        public static final NBTBase NULL_VALUE = new NBTTagCompound();
        public final String optionId;
        public final NBTBase valueTag;

        public OptionEntry(String optionId, NBTBase valueTag) {
            this.optionId = optionId;
            this.valueTag = valueTag == null ? NULL_VALUE : valueTag;
        }

        public static <T> OptionEntry of(ConfigOption<T> option, T value) {
            ConfigValueSyncCodec<T, NBTBase> syncCodec = option.getValueType().getSyncCodec();
            NBTBase valueTag = value == null ? null : syncCodec.encode(value);
            return new OptionEntry(option.getId(), valueTag);
        }

        public static <T> OptionEntry of(Config config, ConfigOption<T> option) {
            return OptionEntry.of(option, config.get(option));
        }
    }
}

