/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import xaero.lib.XaeroLib;
import xaero.lib.common.packet.XaeroPacket;
import xaero.lib.common.player.ServerPlayerData;
import xaero.lib.platform.Services;

public class ConfigChannelPacket
extends XaeroPacket {
    private ResourceLocation channelId;

    public ConfigChannelPacket(ResourceLocation channelId) {
        this.channelId = channelId;
    }

    public ConfigChannelPacket() {
    }

    @Override
    public void write(PacketBuffer buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setString("c", this.channelId.toString());
        buf.writeCompoundTag(tag);
    }

    @Override
    public void read(PacketBuffer buf) {
        NBTTagCompound tag = this.readTag(buf, new NBTSizeTracker(65536L));
        if (tag == null) {
            return;
        }
        String channelIdString = tag.getString("c");
        this.channelId = new ResourceLocation(channelIdString);
    }

    public static final class ServerHandler
    implements BiConsumer<ConfigChannelPacket, EntityPlayerMP> {
        @Override
        public void accept(ConfigChannelPacket packet, EntityPlayerMP player) {
            block2: {
                try {
                    ServerPlayerData.get(player).getConfigSynchronizer().receiveChannelId(packet.channelId);
                }
                catch (Throwable t) {
                    ServerPlayerData.get(player).getConfigSynchronizer().receiveChannelId(null);
                    if (!Services.PLATFORM.isDevelopmentEnvironment()) break block2;
                    XaeroLib.LOGGER.error("packet error", t);
                }
            }
        }
    }

    public static final class ClientHandler
    implements Consumer<ConfigChannelPacket> {
        @Override
        public void accept(ConfigChannelPacket packet) {
            try {
                XaeroLib.INSTANCE.getClient().getConfigSynchronizer().receiveChannelId(packet.channelId);
            }
            catch (Throwable t) {
                XaeroLib.LOGGER.error("packet error", t);
            }
        }
    }
}

