/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config.profile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import xaero.lib.XaeroLib;
import xaero.lib.client.config.sync.ClientConfigSynchronizer;
import xaero.lib.common.packet.XaeroPacket;
import xaero.lib.common.player.ServerPlayerData;
import xaero.lib.platform.Services;

public final class ConfigProfileInfoPacket
extends XaeroPacket {
    private List<Entry> entries;
    private String defaultEnforcedProfileId;
    private boolean reset;

    public ConfigProfileInfoPacket(List<Entry> entries, String defaultEnforcedProfileId, boolean reset) {
        this.entries = entries;
        this.defaultEnforcedProfileId = defaultEnforcedProfileId;
        this.reset = reset;
    }

    public ConfigProfileInfoPacket(String id, String name, String defaultEnforcedProfileId) {
        this(Lists.newArrayList((Object[])new Entry[]{new Entry(id, name)}), defaultEnforcedProfileId, false);
    }

    public ConfigProfileInfoPacket(List<Entry> entries) {
        this(entries, null, false);
    }

    public ConfigProfileInfoPacket(String id, String name) {
        this(Lists.newArrayList((Object[])new Entry[]{new Entry(id, name)}), null, false);
    }

    public ConfigProfileInfoPacket() {
    }

    @Override
    public void write(PacketBuffer buffer) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList entriesTag = new NBTTagList();
        for (Entry entry : this.entries) {
            NBTTagCompound entryTag = new NBTTagCompound();
            entryTag.setString("i", entry.id);
            entryTag.setString("n", entry.name);
            entriesTag.appendTag((NBTBase)entryTag);
        }
        tag.setTag("e", (NBTBase)entriesTag);
        if (this.defaultEnforcedProfileId != null) {
            tag.setString("d", this.defaultEnforcedProfileId);
        }
        tag.setBoolean("r", this.reset);
        buffer.writeCompoundTag(tag);
    }

    @Override
    public void read(PacketBuffer buffer) {
        NBTTagCompound tag = this.readUnlimitedTag(buffer);
        if (tag == null) {
            return;
        }
        this.entries = new ArrayList<Entry>();
        NBTTagList entriesTag = tag.getTagList("e", 10);
        for (NBTBase entryTag : entriesTag) {
            NBTTagCompound entryTagCast = (NBTTagCompound)entryTag;
            String id = entryTagCast.getString("i");
            String name = entryTagCast.getString("n");
            this.entries.add(new Entry(id, name));
        }
        this.defaultEnforcedProfileId = tag.hasKey("d", 8) ? tag.getString("d") : null;
        this.reset = tag.getBoolean("r");
    }

    public static final class ClientHandler
    implements Consumer<ConfigProfileInfoPacket> {
        @Override
        public void accept(ConfigProfileInfoPacket packet) {
            try {
                ClientConfigSynchronizer synchronizer = XaeroLib.INSTANCE.getClient().getConfigSynchronizer();
                synchronizer.onConfigProfileInfoPacket(packet.entries, packet.defaultEnforcedProfileId, packet.reset);
            }
            catch (Throwable t) {
                XaeroLib.LOGGER.error("packet error", t);
            }
        }
    }

    public static final class ServerHandler
    implements BiConsumer<ConfigProfileInfoPacket, EntityPlayerMP> {
        @Override
        public void accept(ConfigProfileInfoPacket packet, EntityPlayerMP player) {
            block2: {
                try {
                    ServerPlayerData.get(player).getConfigSynchronizer().onConfigProfileInfoPacket(packet.entries, packet.defaultEnforcedProfileId);
                }
                catch (Throwable t) {
                    if (!Services.PLATFORM.isDevelopmentEnvironment()) break block2;
                    XaeroLib.LOGGER.error("packet error", t);
                }
            }
        }
    }

    public static final class Entry {
        public final String id;
        public final String name;

        public Entry(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

