/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.platform.services;

import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import xaero.lib.client.controls.util.IKeyMappingHelper;
import xaero.lib.client.controls.util.KeyMappingHelperForge;
import xaero.lib.client.graphics.util.IPlatformRenderHelper;
import xaero.lib.client.graphics.util.RenderHelperForge;
import xaero.lib.common.compat.ForgeModCompatibility;
import xaero.lib.common.compat.PlatformModCompatibility;
import xaero.lib.common.packet.IPacketHandler;
import xaero.lib.common.packet.PacketHandlerForge;
import xaero.lib.common.reflection.util.ObfuscatedReflectionForge;
import xaero.lib.platform.services.IPlatformHelper;

public class PlatformHelperForge
implements IPlatformHelper {
    private final KeyMappingHelperForge keyMappingHelper = new KeyMappingHelperForge();
    private final RenderHelperForge renderHelper = new RenderHelperForge();
    private final ObfuscatedReflectionForge obfuscatedReflection = new ObfuscatedReflectionForge();

    @Override
    public String getPlatformName() {
        return "Forge";
    }

    @Override
    public boolean isModLoaded(String modId) {
        return Loader.isModLoaded((String)modId);
    }

    @Override
    public boolean isDevelopmentEnvironment() {
        return false;
    }

    @Override
    public boolean isDedicatedServer() {
        return FMLCommonHandler.instance().getSide() == Side.SERVER;
    }

    @Override
    public IKeyMappingHelper getKeyMappingHelper() {
        return this.keyMappingHelper;
    }

    @Override
    public IPlatformRenderHelper getPlatformRenderHelper() {
        return this.renderHelper;
    }

    @Override
    public ObfuscatedReflectionForge getObfuscatedReflection() {
        return this.obfuscatedReflection;
    }

    @Override
    public IPacketHandler createPacketHandler(ResourceLocation channelId, int protocolVersion, String platformVersionString) {
        return PacketHandlerForge.Builder.begin().setChannelId(channelId).setProtocolVersion(platformVersionString).build();
    }

    @Override
    public PlatformModCompatibility createPlatformModCompatibility() {
        return new ForgeModCompatibility();
    }

    @Override
    public Path getGameDir() {
        return Minecraft.getMinecraft().mcDataDir.toPath();
    }

    @Override
    public Path getConfigDir() {
        return Loader.instance().getConfigDir().toPath();
    }
}

