/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import xaero.lib.XaeroLib;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.util.GuiUtils;
import xaero.lib.client.gui.widget.GuiActionButton;
import xaero.lib.client.gui.widget.MyTinyButton;
import xaero.lib.client.gui.widget.online.GuiWidgetButton;
import xaero.lib.client.gui.widget.online.WidgetScreen;
import xaero.lib.common.util.KeySortableByOther;

public abstract class GuiSettings
extends ScreenBase
implements WidgetScreen {
    protected int entriesPerPage = 12;
    protected ISettingEntry[] entries;
    private boolean buttonClicked;
    protected String entryFilter = "";
    private boolean foundSomething;
    protected ITextComponent screenTitle;
    protected int page;
    protected int maxPage;
    private MyTinyButton nextButton;
    private MyTinyButton prevButton;
    protected GuiTextField searchField;
    protected boolean canSearch = true;
    private boolean shouldRefocusSearch;
    protected boolean confirmButton;

    public GuiSettings(ITextComponent title, GuiScreen backScreen, GuiScreen escScreen) {
        this(title, backScreen, escScreen, false);
    }

    public GuiSettings(ITextComponent title, GuiScreen backScreen, GuiScreen escScreen, boolean confirmButton) {
        super(backScreen, escScreen, title);
        this.confirmButton = confirmButton;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.screenTitle = this.title;
        this.field_146292_n.clear();
        if (this.confirmButton) {
            this.field_146292_n.add(new GuiActionButton(this.field_146294_l / 2 - 105, this.field_146295_m / 6 + 168, 100, 20, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0])){

                @Override
                protected void onPress() {
                    GuiSettings.this.confirm();
                }
            });
            this.field_146292_n.add(new GuiActionButton(this.field_146294_l / 2 + 5, this.field_146295_m / 6 + 168, 100, 20, I18n.func_135052_a((String)"gui.xaero_back", (Object[])new Object[0])){

                @Override
                protected void onPress() {
                    GuiSettings.this.goBack();
                }
            });
        } else {
            this.field_146292_n.add(new GuiActionButton(this.field_146294_l / 2 - 100, this.field_146295_m / 6 + 168, 200, 20, I18n.func_135052_a((String)"gui.xaero_back", (Object[])new Object[0])){

                @Override
                protected void onPress() {
                    GuiSettings.this.goBack();
                }
            });
        }
        int verticalOffset = this.getVerticalOffset();
        if (this.entries != null) {
            ArrayList<KeySortableByOther<ISettingEntry>> sortingList = new ArrayList<KeySortableByOther<ISettingEntry>>();
            String comparisonFilter = this.entryFilter.toLowerCase();
            for (int i = 0; i < this.entries.length; ++i) {
                int positionInEntryString;
                ISettingEntry entry = this.entries[i];
                String entrySearchString = entry.getStringForSearch().toLowerCase();
                if (entrySearchString == null || (positionInEntryString = entrySearchString.indexOf(comparisonFilter)) == -1) continue;
                KeySortableByOther<ISettingEntry> sortableEntry = new KeySortableByOther<ISettingEntry>(entry, Integer.valueOf(positionInEntryString));
                sortingList.add(sortableEntry);
            }
            List filteredEntries = sortingList.stream().sorted().map(new Function<KeySortableByOther<ISettingEntry>, ISettingEntry>(){

                @Override
                public ISettingEntry apply(KeySortableByOther<ISettingEntry> sortingKey) {
                    return sortingKey.getKey();
                }
            }).collect(Collectors.toList());
            if (!filteredEntries.isEmpty()) {
                this.foundSomething = true;
                this.maxPage = (int)Math.ceil((double)filteredEntries.size() / (double)this.entriesPerPage) - 1;
                if (this.page > this.maxPage) {
                    this.page = this.maxPage;
                }
                int firstEntry = this.entriesPerPage * this.page;
                int entryCount = Math.min(filteredEntries.size() - firstEntry, this.entriesPerPage);
                for (int i = 0; i < entryCount; ++i) {
                    ISettingEntry entry = (ISettingEntry)filteredEntries.get(firstEntry + i);
                    GuiButton optionWidget = entry.createWidget(this.field_146294_l / 2 - 205 + i % 2 * 210, this.field_146295_m / 7 + 5 + verticalOffset + 24 * (i >> 1), 200, this.field_146294_l);
                    this.func_189646_b(optionWidget);
                }
            } else {
                this.foundSomething = false;
                this.page = 0;
                this.maxPage = 0;
            }
        }
        this.screenTitle = this.screenTitle.func_150259_f().func_150258_a(" (" + (this.page + 1) + "/" + (this.maxPage + 1) + ")");
        this.nextButton = new MyTinyButton(this.field_146294_l / 2 + 131, this.field_146295_m / 7 + 149 + verticalOffset, I18n.func_135052_a((String)"gui.xaero_next", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                GuiSettings.this.onNextButton();
            }
        };
        this.prevButton = new MyTinyButton(this.field_146294_l / 2 - 205, this.field_146295_m / 7 + 149 + verticalOffset, I18n.func_135052_a((String)"gui.xaero_previous", (Object[])new Object[0])){

            @Override
            protected void onPress() {
                GuiSettings.this.onPrevButton();
            }
        };
        if (this.maxPage > 0) {
            this.func_189646_b(this.nextButton);
            this.func_189646_b(this.prevButton);
            this.nextButton.field_146124_l = this.page < this.maxPage;
            this.prevButton.field_146124_l = this.page > 0;
        }
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().initialize(this, this.field_146294_l, this.field_146295_m);
        boolean shouldFocusSearch = this.shouldRefocusSearch;
        this.shouldRefocusSearch = false;
        if (this.canSearch && this.entries != null) {
            int cursorPos = 0;
            if (shouldFocusSearch) {
                cursorPos = this.searchField.func_146198_h();
            }
            this.searchField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 100, this.field_146295_m / 7 + 5 + verticalOffset - 24, 200, 20);
            this.searchField.func_146180_a(this.entryFilter);
            this.textFields.add(this.searchField);
            if (shouldFocusSearch) {
                this.setFocusedTextField(this.searchField);
                this.searchField.func_146190_e(cursorPos);
                this.searchField.func_146199_i(cursorPos);
            }
        } else {
            this.searchField = null;
        }
    }

    protected void confirm() {
        this.onExit(this.escape);
    }

    protected int getVerticalOffset() {
        return this.canSearch ? 24 : 0;
    }

    @Override
    protected void func_146284_a(GuiButton par1GuiButton) throws IOException {
        super.func_146284_a(par1GuiButton);
        this.buttonClicked = true;
        if (par1GuiButton.field_146124_l) {
            int var2 = this.field_146297_k.field_71474_y.field_74335_Z;
            if (par1GuiButton instanceof GuiWidgetButton) {
                XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().handleButton(this, (GuiWidgetButton)par1GuiButton);
            }
            if (this.field_146297_k.field_71474_y.field_74335_Z != var2) {
                ScaledResolution var3 = new ScaledResolution(this.field_146297_k);
                int var4 = var3.func_78326_a();
                int var5 = var3.func_78328_b();
                this.func_146280_a(this.field_146297_k, var4, var5);
            }
        }
    }

    @Override
    protected void renderPreDropdown(int mouseX, int mouseY, float partial) {
        super.renderPreDropdown(mouseX, mouseY, partial);
        if (this.searchField != null && !this.foundSomething && this.entries != null) {
            this.func_73732_a(this.field_146297_k.field_71466_p, I18n.func_135052_a((String)"gui.xaero_settings_not_found", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m / 7 + 34, 0xFFFFFF);
        }
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        int verticalOffset = this.getVerticalOffset();
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().render(this, this.field_146294_l, this.field_146295_m, par1, par2, this.guiScaleFactor);
        this.func_73732_a(this.field_146289_q, this.screenTitle.func_150254_d(), this.field_146294_l / 2, this.field_146295_m / 7 + 29 - 42, 0xFFFFFF);
        if (this.searchField != null && !this.searchField.func_146206_l() && this.searchField.func_146179_b().isEmpty()) {
            GuiUtils.setFieldText(this.searchField, I18n.func_135052_a((String)"gui.xaero_settings_search_placeholder", (Object[])new Object[0]), -11184811);
            this.searchField.func_146190_e(0);
        }
        super.func_73863_a(par1, par2, par3);
        if (this.searchField != null && !this.searchField.func_146206_l()) {
            GuiUtils.setFieldText(this.searchField, this.entryFilter);
        }
        if (this.openDropdown == null) {
            this.renderTooltips(par1, par2, par3);
        }
    }

    @Override
    public void addButtonVisible(GuiButton button) {
        this.func_189646_b(button);
    }

    @Override
    public <S extends GuiScreen> S getScreen() {
        return (S)this;
    }

    @Override
    public void onExit(GuiScreen screen) {
        super.onExit(screen);
    }

    @Override
    public void func_73869_a(char par1, int par2) throws IOException {
        super.func_73869_a(par1, par2);
        if (this.searchField != null) {
            this.updateSearch();
        }
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().handleClick(this, this.field_146294_l, this.field_146295_m, mouseX, mouseY, this.guiScaleFactor);
        this.buttonClicked = false;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (!this.buttonClicked) {
            // empty if block
        }
    }

    protected void onNextButton() {
        ++this.page;
        this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
    }

    protected void onPrevButton() {
        --this.page;
        this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
    }

    public ISettingEntry[] getEntriesCopy() {
        if (this.entries == null) {
            return null;
        }
        ISettingEntry[] result = new ISettingEntry[this.entries.length];
        System.arraycopy(this.entries, 0, result, 0, this.entries.length);
        return result;
    }

    private void updateSearch() {
        String newValue;
        if (this.searchField.func_146206_l() && !Objects.equal((Object)this.entryFilter, (Object)(newValue = this.searchField.func_146179_b()))) {
            this.entryFilter = this.searchField.func_146179_b();
            this.shouldRefocusSearch = true;
            this.page = 0;
            this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        }
    }
}

