/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import xaero.lib.XaeroLib;
import xaero.lib.client.gui.IScreenBase;
import xaero.lib.client.gui.widget.GuiActionButton;
import xaero.lib.client.gui.widget.ITooltipHaver;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.XaeroSliderWidget;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;

public class ScreenBase
extends GuiScreen
implements IScreenBase {
    public GuiScreen parent;
    public GuiScreen escape;
    protected boolean canSkipWorldRender;
    protected int guiScaleFactor;
    protected DropDownWidget openDropdown;
    private List<DropDownWidget> dropdowns;
    protected GuiTextField focusedTextField;
    protected final List<GuiTextField> textFields;
    protected boolean handledMouseInput;
    protected boolean handledKeyboardInput;
    protected boolean shouldRefresh;
    protected ITextComponent title;

    protected ScreenBase(GuiScreen parent, GuiScreen escape, ITextComponent titleIn) {
        this.parent = parent;
        this.escape = escape;
        this.title = titleIn;
        this.dropdowns = new ArrayList<DropDownWidget>();
        this.textFields = new ArrayList<GuiTextField>();
    }

    public void onExit(GuiScreen screen) {
        this.field_146297_k.func_147108_a(screen);
    }

    public void goBack() {
        this.onExit(this.parent);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.onClose();
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
            this.handledKeyboardInput = true;
            return;
        }
        if (this.focusedTextField != null) {
            this.handledKeyboardInput = this.focusedTextField.func_146201_a(typedChar, keyCode);
        }
    }

    public void onClose() {
        this.onExit(this.escape);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.handledMouseInput = true;
        if (button instanceof GuiActionButton) {
            ((GuiActionButton)button).press();
            return;
        }
        super.func_146284_a(button);
    }

    public void renderEscapeScreen(int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        if (this.escape != null) {
            this.escape.func_73863_a(p_230430_2_, p_230430_3_, p_230430_4_);
            GlStateManager.func_179086_m((int)256);
        }
    }

    public void func_146276_q_() {
        this.handleRefresh();
        super.func_146276_q_();
    }

    public void func_73863_a(int mouseX, int mouseY, float partial) {
        this.handleRefresh();
        super.func_73863_a(mouseX, mouseY, partial);
        this.textFields.forEach(new Consumer<GuiTextField>(){

            @Override
            public void accept(GuiTextField field) {
                field.func_146194_f();
            }
        });
        this.renderPreDropdown(mouseX, mouseY, partial);
        for (DropDownWidget dropdown : this.dropdowns) {
            dropdown.render(mouseX, mouseY, this.field_146295_m, true);
        }
        if (this.openDropdown != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)2.0f);
            this.openDropdown.render(mouseX, mouseY, this.field_146295_m, false);
            GlStateManager.func_179121_F();
        }
    }

    protected void renderPreDropdown(int mouseX, int mouseY, float partial) {
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ScaledResolution var3 = new ScaledResolution(this.field_146297_k);
        this.guiScaleFactor = var3.func_78325_e();
        this.dropdowns.clear();
        this.openDropdown = null;
        this.textFields.clear();
        this.focusedTextField = null;
        Keyboard.enableRepeatEvents((boolean)true);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_146280_a(Minecraft p_231158_1_, int p_231158_2_, int p_231158_3_) {
        super.func_146280_a(p_231158_1_, p_231158_2_, p_231158_3_);
        if (this.escape != null) {
            this.escape.func_146280_a(p_231158_1_, p_231158_2_, p_231158_3_);
        }
    }

    public void setFocusedTextField(GuiTextField textField) {
        if (this.focusedTextField != null) {
            this.focusedTextField.func_146195_b(false);
        }
        this.focusedTextField = textField;
        if (textField != null) {
            textField.func_146195_b(true);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (this.openDropdown != null) {
            if (!this.openDropdown.onDropDown(mouseX, mouseY, this.field_146295_m)) {
                this.openDropdown.setClosed(true);
                this.openDropdown = null;
            } else {
                if (button == 0) {
                    this.openDropdown.func_146116_c(this.field_146297_k, mouseX, mouseY);
                }
                this.handledMouseInput = true;
                return;
            }
        }
        super.func_73864_a(mouseX, mouseY, button);
        if (this.handledMouseInput) {
            return;
        }
        for (GuiTextField textField : this.textFields) {
            if (!textField.func_146192_a(mouseX, mouseY, button)) continue;
            this.setFocusedTextField(textField);
            this.handledMouseInput = true;
            return;
        }
        this.setFocusedTextField(null);
    }

    public void func_146274_d() throws IOException {
        this.handledMouseInput = false;
        super.func_146274_d();
        if (this.handledMouseInput) {
            return;
        }
        int wheel = Mouse.getEventDWheel() / 120;
        if (wheel != 0) {
            ScaledResolution var3 = new ScaledResolution(this.field_146297_k);
            int mouseXScaled = Mouse.getX() / var3.func_78325_e();
            int mouseYScaled = var3.func_78328_b() - 1 - Mouse.getY() / var3.func_78325_e();
            if (this.openDropdown != null && this.openDropdown.onDropDown(mouseXScaled, mouseYScaled, this.field_146295_m)) {
                this.openDropdown.mouseScrolled(wheel, mouseXScaled, mouseYScaled, this.field_146295_m);
            }
        }
    }

    public void func_146282_l() throws IOException {
        this.handledKeyboardInput = false;
        super.func_146282_l();
    }

    protected void func_146286_b(int mouseX, int mouseY, int button) {
        if (this.openDropdown != null && button == 0) {
            this.openDropdown.func_146118_a(mouseX, mouseY);
        }
        super.func_146286_b(mouseX, mouseY, button);
    }

    @Override
    public boolean shouldSkipWorldRender() {
        return this.canSkipWorldRender && this.escape instanceof IScreenBase && ((IScreenBase)this.escape).shouldSkipWorldRender();
    }

    protected boolean renderTooltips(int par1, int par2, float par3) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)2.1);
        boolean result = XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().renderTooltips(this, this.field_146294_l, this.field_146295_m, par1, par2, this.guiScaleFactor);
        boolean mousePressed = Mouse.isButtonDown((int)0);
        for (int k = 0; k < this.field_146292_n.size(); ++k) {
            Tooltip tooltip;
            GuiButton b = (GuiButton)this.field_146292_n.get(k);
            if (!(b instanceof ITooltipHaver) || b instanceof XaeroSliderWidget && mousePressed) continue;
            ITooltipHaver optionWidget = (ITooltipHaver)b;
            if (par1 < b.field_146128_h || par2 < b.field_146129_i || par1 >= b.field_146128_h + b.field_146120_f || par2 >= b.field_146129_i + b.field_146121_g || optionWidget.getXaero_tooltip() == null || (tooltip = optionWidget.getXaero_tooltip().get()) == null) continue;
            tooltip.drawBox(par1, par2, this.field_146294_l, this.field_146295_m);
            result = true;
            break;
        }
        GlStateManager.func_179121_F();
        return result;
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiTextField textField : this.textFields) {
            textField.func_146178_a();
        }
    }

    @Override
    public void onDropdownOpen(DropDownWidget menu) {
        if (this.openDropdown != null && this.openDropdown != menu) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = menu;
    }

    @Override
    public void onDropdownClosed(DropDownWidget menu) {
        if (menu != this.openDropdown && this.openDropdown != null) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = null;
    }

    protected void addWidget(DropDownWidget guiEventListener) {
        this.dropdowns.add(guiEventListener);
        this.field_146292_n.add(guiEventListener);
    }

    public void replaceWidget(GuiButton current, GuiButton replacement) {
        int dropdownIndex;
        int buttonIndex = this.field_146292_n.indexOf(current);
        if (buttonIndex != -1) {
            this.field_146292_n.set(buttonIndex, replacement);
        }
        if ((dropdownIndex = this.dropdowns.indexOf(current)) != -1) {
            this.dropdowns.set(dropdownIndex, (DropDownWidget)replacement);
        }
    }

    public void removeWidget(GuiButton current) {
        this.field_146292_n.remove(current);
        this.dropdowns.remove(current);
    }

    @Override
    public GuiScreen getEscape() {
        return this.escape;
    }

    public static GuiScreen tryToGetEscape(GuiScreen screen) {
        if (screen instanceof IScreenBase) {
            return ((IScreenBase)screen).getEscape();
        }
        return null;
    }

    public void refresh() {
        this.shouldRefresh = true;
    }

    protected final void handleRefresh() {
        if (!this.shouldRefresh) {
            return;
        }
        this.shouldRefresh = false;
        this.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
    }

    public int getIndex(GuiButton child) {
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            if (this.field_146292_n.get(i) != child) continue;
            return i;
        }
        return -1;
    }

    public boolean canSkipWorldRender() {
        return this.canSkipWorldRender;
    }
}

