/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.event;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import xaero.lib.common.config.channel.ConfigChannel;
import xaero.lib.common.config.channel.register.ConfigChannelRegistry;
import xaero.lib.common.player.IServerPlayer;
import xaero.lib.common.player.ServerPlayerData;
import xaero.lib.common.player.ServerPlayerLoginHandler;
import xaero.lib.common.player.ServerPlayerTickHandler;

public class CommonEvents {
    private final ServerPlayerTickHandler playerTickHandler = new ServerPlayerTickHandler();

    public void clonePlayer(EntityPlayer from, EntityPlayer to) {
        if (!(to instanceof IServerPlayer)) {
            return;
        }
        ((IServerPlayer)to).xaerolib_setData(((IServerPlayer)from).xaerolib_getData());
        ((IServerPlayer)to).xaerolib_getData().setPlayer((EntityPlayerMP)to);
    }

    public void playerLogIn(EntityPlayer player) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP serverPlayer = (EntityPlayerMP)player;
        new ServerPlayerLoginHandler().handle(serverPlayer);
    }

    public void onPlayerTick(boolean isTickStart, boolean isServerSide, EntityPlayer player) {
        if (!isTickStart || !isServerSide) {
            return;
        }
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        this.playerTickHandler.handle((EntityPlayerMP)player);
    }

    public void serverStarting(MinecraftServer server) {
        for (ConfigChannel configChannel : ConfigChannelRegistry.INSTANCE) {
            configChannel.getServerConfigManager().setServer(server);
        }
    }

    public void onPlayerPermissionChange(EntityPlayer player) {
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        ServerPlayerData.get((EntityPlayerMP)player).setShouldUpdateConfigPermissions(true);
    }
}

