/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import xaero.lib.common.packet.IPacketHandler;
import xaero.lib.common.packet.PacketConsumerForge;
import xaero.lib.common.packet.XaeroPacket;
import xaero.lib.common.player.ServerPlayerData;

public class PacketHandlerForge
implements IPacketHandler {
    public final SimpleNetworkWrapper network;
    private final ResourceLocation channelId;

    private PacketHandlerForge(ResourceLocation channelId, String protocolVersion) {
        this.channelId = channelId;
        this.network = NetworkRegistry.INSTANCE.newSimpleChannel(channelId.toString());
    }

    @Override
    public ResourceLocation getChannelId() {
        return this.channelId;
    }

    @Override
    public <P extends XaeroPacket> void register(int index, Class<P> type, BiConsumer<P, EntityPlayerMP> serverHandler, Consumer<P> clientHandler) {
        PacketConsumerForge<P> consumer = new PacketConsumerForge<P>(serverHandler, clientHandler);
        if (serverHandler != null) {
            this.network.registerMessage(consumer, type, index, Side.SERVER);
        }
        if (clientHandler != null) {
            this.network.registerMessage(consumer, type, index, Side.CLIENT);
        }
    }

    public void sendToServer(XaeroPacket packet) {
        this.network.sendToServer((IMessage)packet);
    }

    public void sendToPlayer(EntityPlayerMP player, XaeroPacket packet) {
        this.network.sendTo((IMessage)packet, player);
    }

    @Override
    public <T extends XaeroPacket> void sendToPlayer(ServerPlayerData playerData, T packet) {
        this.sendToPlayer(playerData.getPlayer(), (XaeroPacket)packet);
    }

    public static final class Builder {
        private ResourceLocation channelId;
        private String protocolVersion;

        private Builder() {
        }

        public Builder setDefault() {
            this.setChannelId(null);
            this.setProtocolVersion(null);
            return this;
        }

        public Builder setChannelId(ResourceLocation channelId) {
            this.channelId = channelId;
            return this;
        }

        public Builder setProtocolVersion(String protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public PacketHandlerForge build() {
            if (this.channelId == null || this.protocolVersion == null) {
                throw new IllegalStateException();
            }
            return new PacketHandlerForge(this.channelId, this.protocolVersion);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

