/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui;

import com.google.common.base.Objects;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.lib.XaeroLib;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.util.GuiUtils;
import xaero.lib.client.gui.widget.MyTinyButton;
import xaero.lib.client.gui.widget.online.WidgetScreen;
import xaero.lib.common.util.KeySortableByOther;

public abstract class GuiSettings
extends ScreenBase
implements WidgetScreen {
    protected int entriesPerPage = 12;
    protected ISettingEntry[] entries;
    protected String entryFilter = "";
    private boolean foundSomething;
    protected ITextComponent screenTitle;
    protected int page;
    protected int maxPage;
    private MyTinyButton nextButton;
    private MyTinyButton prevButton;
    protected TextFieldWidget searchField;
    protected boolean canSearch = true;
    private boolean shouldRefocusSearch;
    protected boolean confirmButton;

    public GuiSettings(ITextComponent title, Screen backScreen, Screen escScreen) {
        this(title, backScreen, escScreen, false);
    }

    public GuiSettings(ITextComponent title, Screen backScreen, Screen escScreen, boolean confirmButton) {
        super(backScreen, escScreen, title);
        this.confirmButton = confirmButton;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.screenTitle = this.field_230704_d_;
        if (this.confirmButton) {
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 105, this.field_230709_l_ / 6 + 168, 100, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_confirm"), b -> this.confirm()));
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 5, this.field_230709_l_ / 6 + 168, 100, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_back"), b -> this.goBack()));
        } else {
            this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 6 + 168, 200, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_back", new Object[0]), b -> this.goBack()));
        }
        int verticalOffset = this.getVerticalOffset();
        if (this.entries != null) {
            ArrayList<KeySortableByOther<ISettingEntry>> sortingList = new ArrayList<KeySortableByOther<ISettingEntry>>();
            String comparisonFilter = this.entryFilter.toLowerCase();
            for (int i = 0; i < this.entries.length; ++i) {
                int positionInEntryString;
                ISettingEntry entry = this.entries[i];
                String entrySearchString = entry.getStringForSearch().toLowerCase();
                if (entrySearchString == null || (positionInEntryString = entrySearchString.indexOf(comparisonFilter)) == -1) continue;
                KeySortableByOther<ISettingEntry> sortableEntry = new KeySortableByOther<ISettingEntry>(entry, Integer.valueOf(positionInEntryString));
                sortingList.add(sortableEntry);
            }
            ArrayList filteredEntries = sortingList.stream().sorted().map(KeySortableByOther::getKey).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            if (!filteredEntries.isEmpty()) {
                this.foundSomething = true;
                this.maxPage = (int)Math.ceil((double)filteredEntries.size() / (double)this.entriesPerPage) - 1;
                if (this.page > this.maxPage) {
                    this.page = this.maxPage;
                }
                int firstEntry = this.entriesPerPage * this.page;
                int entryCount = Math.min(filteredEntries.size() - firstEntry, this.entriesPerPage);
                for (int i = 0; i < entryCount; ++i) {
                    ISettingEntry entry = (ISettingEntry)filteredEntries.get(firstEntry + i);
                    Widget optionWidget = entry.createWidget(this.field_230708_k_ / 2 - 205 + i % 2 * 210, this.field_230709_l_ / 7 + 5 + verticalOffset + 24 * (i >> 1), 200);
                    this.func_230480_a_(optionWidget);
                }
            } else {
                this.foundSomething = false;
                this.page = 0;
                this.maxPage = 0;
            }
        }
        this.screenTitle = this.screenTitle.func_230531_f_().func_240702_b_(" (" + (this.page + 1) + "/" + (this.maxPage + 1) + ")");
        this.nextButton = new MyTinyButton(this.field_230708_k_ / 2 + 131, this.field_230709_l_ / 7 + 149 + verticalOffset, (ITextComponent)new TranslationTextComponent("gui.xaero_next", new Object[0]), b -> this.onNextButton());
        this.prevButton = new MyTinyButton(this.field_230708_k_ / 2 - 205, this.field_230709_l_ / 7 + 149 + verticalOffset, (ITextComponent)new TranslationTextComponent("gui.xaero_previous", new Object[0]), b -> this.onPrevButton());
        if (this.maxPage > 0) {
            this.func_230480_a_((Widget)this.nextButton);
            this.func_230480_a_((Widget)this.prevButton);
            this.nextButton.field_230693_o_ = this.page < this.maxPage;
            this.prevButton.field_230693_o_ = this.page > 0;
        }
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().initialize(this, this.field_230708_k_, this.field_230709_l_);
        boolean shouldFocusSearch = this.shouldRefocusSearch;
        this.shouldRefocusSearch = false;
        if (this.canSearch && this.entries != null) {
            int cursorPos = 0;
            if (shouldFocusSearch) {
                cursorPos = this.searchField.func_146198_h();
            }
            this.searchField = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 7 + 5 + verticalOffset - 24, 200, 20, (ITextComponent)new TranslationTextComponent("gui.xaero_settings_search"));
            this.searchField.func_146180_a(this.entryFilter);
            if (shouldFocusSearch) {
                this.func_231035_a_((IGuiEventListener)this.searchField);
                this.searchField.func_146195_b(true);
                this.searchField.func_212422_f(cursorPos);
                this.searchField.func_146199_i(cursorPos);
            }
            this.searchField.func_212954_a(s -> {
                if (this.canSearch) {
                    this.updateSearch();
                }
            });
            this.field_230705_e_.add(this.searchField);
        } else {
            this.searchField = null;
        }
        this.field_230706_i_.field_195559_v.func_197967_a(true);
    }

    protected void confirm() {
        this.onExit(this.escape);
    }

    protected int getVerticalOffset() {
        return this.canSearch ? 24 : 0;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        if (this.canSearch && this.searchField != null) {
            this.searchField.func_146178_a();
        }
    }

    @Override
    protected void renderPreDropdown(MatrixStack matrixStack, int mouseX, int mouseY, float partial) {
        super.renderPreDropdown(matrixStack, mouseX, mouseY, partial);
        if (this.searchField != null) {
            if (!this.foundSomething && this.entries != null) {
                GuiSettings.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)I18n.func_135052_a((String)"gui.xaero_settings_not_found", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 7 + 34), (int)0xFFFFFF);
            }
            if (!this.searchField.func_230999_j_() && this.searchField.func_146179_b().isEmpty()) {
                GuiUtils.setFieldText(this.searchField, I18n.func_135052_a((String)"gui.xaero_settings_search_placeholder", (Object[])new Object[0]), -11184811);
                this.searchField.func_146190_e(0);
            }
            this.searchField.func_230430_a_(matrixStack, mouseX, mouseY, partial);
            if (!this.searchField.func_230999_j_()) {
                GuiUtils.setFieldText(this.searchField, this.entryFilter);
            }
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int par1, int par2, float par3) {
        this.func_230446_a_(matrixStack);
        int verticalOffset = this.getVerticalOffset();
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().render(matrixStack, this, this.field_230708_k_, this.field_230709_l_, par1, par2, this.field_230706_i_.func_228018_at_().func_198100_s());
        GuiSettings.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (ITextComponent)this.screenTitle, (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 7 + 29 - 42), (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, par1, par2, par3);
        if (this.openDropdown == null) {
            this.renderTooltips(matrixStack, par1, par2, par3);
        }
    }

    @Override
    public void addButtonVisible(Widget button) {
        this.func_230480_a_(button);
    }

    @Override
    public <S extends Screen> S getScreen() {
        return (S)this;
    }

    @Override
    public void onExit(Screen screen) {
        super.onExit(screen);
    }

    public boolean func_231046_a_(int par1, int par2, int par3) {
        return super.func_231046_a_(par1, par2, par3) || this.func_241217_q_() instanceof TextFieldWidget && ((TextFieldWidget)this.func_241217_q_()).func_230999_j_();
    }

    public boolean func_231042_a_(char c, int i) {
        boolean result = super.func_231042_a_(c, i);
        return result;
    }

    @Override
    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().handleClick(this, this.field_230708_k_, this.field_230709_l_, (int)p_mouseClicked_1_, (int)p_mouseClicked_3_, this.field_230706_i_.func_228018_at_().func_198100_s());
        return super.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    protected void onNextButton() {
        ++this.page;
        this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
    }

    protected void onPrevButton() {
        --this.page;
        this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
    }

    public ISettingEntry[] getEntriesCopy() {
        if (this.entries == null) {
            return null;
        }
        ISettingEntry[] result = new ISettingEntry[this.entries.length];
        System.arraycopy(this.entries, 0, result, 0, this.entries.length);
        return result;
    }

    public void func_231035_a_(IGuiEventListener guiEventListener) {
        IGuiEventListener currentFocused = this.func_241217_q_();
        if (currentFocused != guiEventListener && currentFocused instanceof TextFieldWidget) {
            ((TextFieldWidget)currentFocused).func_146195_b(false);
        }
        super.func_231035_a_(guiEventListener);
    }

    private void updateSearch() {
        String newValue;
        if (this.searchField.func_230999_j_() && !Objects.equal((Object)this.entryFilter, (Object)(newValue = this.searchField.func_146179_b()))) {
            this.entryFilter = this.searchField.func_146179_b();
            this.shouldRefocusSearch = true;
            this.page = 0;
            this.func_231158_b_(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_);
        }
    }
}

