/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui.util.graphics;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;

public class GuiGraphicsUtils {
    public static void blit(MatrixStack pose, int x, int y, float u, float v, int w, int h) {
        GuiGraphicsUtils.blit(pose, x, x + w, y, y + h, 0, w, h, u, v, 256, 256);
    }

    public static void blit(MatrixStack pose, int x, int y, int z, float u, float v, int w, int h, int textureW, int textureH) {
        GuiGraphicsUtils.blit(pose, x, x + w, y, y + h, z, w, h, u, v, textureW, textureH);
    }

    static void blit(MatrixStack pose, int left, int right, int top, int bottom, int z, int uw, int vh, float u, float v, int textureW, int textureH) {
        GuiGraphicsUtils.innerBlit(pose, left, right, top, bottom, z, (u + 0.0f) / (float)textureW, (u + (float)uw) / (float)textureW, (v + 0.0f) / (float)textureH, (v + (float)vh) / (float)textureH);
    }

    static void innerBlit(MatrixStack pose, int left, int right, int top, int bottom, int z, float uLeft, float uRight, float vTop, float vBottom) {
        Matrix4f matrix4f = pose.func_227866_c_().func_227870_a_();
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_227888_a_(matrix4f, (float)left, (float)top, (float)z).func_225583_a_(uLeft, vTop).func_181675_d();
        bufferBuilder.func_227888_a_(matrix4f, (float)left, (float)bottom, (float)z).func_225583_a_(uLeft, vBottom).func_181675_d();
        bufferBuilder.func_227888_a_(matrix4f, (float)right, (float)bottom, (float)z).func_225583_a_(uRight, vBottom).func_181675_d();
        bufferBuilder.func_227888_a_(matrix4f, (float)right, (float)top, (float)z).func_225583_a_(uRight, vTop).func_181675_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
    }
}

