/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.config.util;

import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.lib.client.config.option.value.redirect.ClientOptionValueRedirectorManager;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.option.SteppedConfigOption;
import xaero.lib.common.config.util.ConfigConstants;

public class ConfigUtils {
    public static ITextComponent getDisplayForSimpleNumber(ConfigOption<? extends Number> option, Number value, ITextComponent unit) {
        String valueString;
        if (option instanceof SteppedConfigOption) {
            int precision = ((SteppedConfigOption)option).getPrecision();
            String format = "%." + precision + "f";
            valueString = String.format(format, value);
        } else {
            valueString = "" + value;
        }
        StringTextComponent valueComponent = new StringTextComponent(valueString);
        if (unit != null) {
            valueComponent.func_150253_a().add(new StringTextComponent(" "));
            valueComponent.func_150253_a().add(unit);
        }
        return valueComponent;
    }

    public static ITextComponent getDisplayForSimpleNumber(ConfigOption<? extends Number> option, Number value) {
        return ConfigUtils.getDisplayForSimpleNumber(option, value, null);
    }

    public static ITextComponent getDisplayForBoolean(ConfigOption<Boolean> option, Boolean value) {
        return value != false ? ConfigConstants.ON : ConfigConstants.OFF;
    }

    public static ITextComponent getDisplayForString(ConfigOption<String> stringConfigOption, String s) {
        return new StringTextComponent(s);
    }

    public static String getAutoProfileIdForName(Predicate<String> exists, String profileName) {
        String id = profileName.toLowerCase().trim().replaceAll("\\s", "_").replaceAll("[^a-z0-9_]", "");
        if (!id.isEmpty() && !exists.test(id)) {
            return id;
        }
        int i = 0;
        while (exists.test(id = "profile_" + i)) {
            ++i;
        }
        return id;
    }

    public static <T> ITextComponent getEffectiveValueName(ClientOptionValueRedirectorManager redirectorManager, ConfigOption<T> option, Config config, Config enforced) {
        TextComponent configValueText;
        T configValue;
        if (redirectorManager != null && redirectorManager.shouldRedirect(option)) {
            ITextComponent customName = redirectorManager.getName(option);
            if (customName != null) {
                return customName;
            }
            configValue = redirectorManager.getValue(option);
        } else {
            configValue = config.get(option);
        }
        Object object = configValueText = configValue == null ? ConfigConstants.UNSPECIFIED : option.getDisplayGetter().apply((ConfigOption<ConfigOption<T>>)option, (ConfigOption<T>)configValue);
        if (enforced == null) {
            return configValueText;
        }
        T enforcedValue = enforced.get(option);
        if (enforcedValue == null) {
            return configValueText;
        }
        if (Objects.equals(configValue, enforcedValue)) {
            return configValueText;
        }
        IFormattableTextComponent enforcedValueText = option.getDisplayGetter().apply((ConfigOption<ConfigOption<T>>)option, (ConfigOption<T>)enforcedValue).func_230532_e_().func_240699_a_(TextFormatting.YELLOW);
        IFormattableTextComponent combinedName = new TranslationTextComponent("gui.xaero_config_value_enforced", new Object[]{configValueText.func_230532_e_().func_240699_a_(TextFormatting.WHITE), enforcedValueText}).func_240699_a_(TextFormatting.YELLOW);
        return combinedName;
    }

    public static ITextComponent optionNameValue(ITextComponent name, ITextComponent value) {
        return new TranslationTextComponent("options.generic_value", new Object[]{name, value});
    }
}

