/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet;

import io.netty.buffer.Unpooled;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import xaero.lib.common.packet.IPacketHandler;
import xaero.lib.common.packet.type.PacketType;
import xaero.lib.common.packet.type.PacketTypeManager;

public abstract class PacketHandlerFull
implements IPacketHandler {
    protected final ResourceLocation channelId;
    protected final PacketTypeManager packetTypeManager;

    protected PacketHandlerFull(ResourceLocation channelId, PacketTypeManager packetTypeManager) {
        this.channelId = channelId;
        this.packetTypeManager = packetTypeManager;
    }

    @Override
    public <P> void register(int index, Class<P> type, BiConsumer<P, PacketBuffer> encoder, Function<PacketBuffer, P> decoder, BiConsumer<P, ServerPlayerEntity> serverHandler, Consumer<P> clientHandler) {
        this.packetTypeManager.register(index, type, encoder, decoder, serverHandler, clientHandler);
    }

    public static <T> void encodePacket(PacketType<T> packetType, T packet, PacketBuffer buffer) {
        if (packetType == null) {
            throw new IllegalArgumentException("unregistered packet class!");
        }
        buffer.writeByte(packetType.getIndex());
        packetType.getEncoder().accept(packet, buffer);
    }

    <T> PacketBuffer getPacketBuffer(T packet) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
        PacketHandlerFull.encodePacket(this.packetTypeManager.getType(packet), packet, buffer);
        return buffer;
    }

    public PacketType<?> getPacketTypeByIndex(int index) {
        return this.packetTypeManager.getByIndex(index);
    }

    public PacketType<?> getByIndex(int index) {
        return this.packetTypeManager.getByIndex(index);
    }

    @Override
    public ResourceLocation getChannelId() {
        return this.channelId;
    }

    public static abstract class Builder<B extends Builder<B>> {
        private final B self = this;
        protected ResourceLocation channelId;

        protected Builder() {
        }

        public B setDefault() {
            this.setChannelId(null);
            return this.self;
        }

        public B setChannelId(ResourceLocation channelId) {
            this.channelId = channelId;
            return this.self;
        }

        public PacketHandlerFull build() {
            if (this.channelId == null) {
                throw new IllegalStateException();
            }
            PacketTypeManager packetTypeManager = PacketTypeManager.Builder.begin().build();
            return this.buildInternal(packetTypeManager);
        }

        protected abstract PacketHandlerFull buildInternal(PacketTypeManager var1);
    }
}

