/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.common.packet.config.profile;

import java.util.function.BiConsumer;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.network.PacketBuffer;
import xaero.lib.XaeroLib;
import xaero.lib.common.player.ServerPlayerData;
import xaero.lib.platform.Services;

public final class ServerboundConfigProfileRequestPacket {
    private final String profileId;

    public ServerboundConfigProfileRequestPacket(String profileId) {
        this.profileId = profileId;
    }

    public void write(PacketBuffer buffer) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("i", this.profileId);
        buffer.func_150786_a(tag);
    }

    public static ServerboundConfigProfileRequestPacket read(PacketBuffer buffer) {
        try {
            CompoundNBT tag = buffer.func_244272_a(new NBTSizeTracker(65536L));
            if (tag == null) {
                return null;
            }
            String profileId = tag.func_74779_i("i");
            return new ServerboundConfigProfileRequestPacket(profileId);
        }
        catch (Throwable t) {
            if (Services.PLATFORM.isDevelopmentEnvironment()) {
                XaeroLib.LOGGER.error("packet error", t);
            }
            return null;
        }
    }

    public static final class ServerHandler
    implements BiConsumer<ServerboundConfigProfileRequestPacket, ServerPlayerEntity> {
        @Override
        public void accept(ServerboundConfigProfileRequestPacket packet, ServerPlayerEntity player) {
            block2: {
                try {
                    ServerPlayerData.get(player).getConfigSynchronizer().onProfileRequestPacket(packet.profileId);
                }
                catch (Throwable t) {
                    if (!Services.PLATFORM.isDevelopmentEnvironment()) break block2;
                    XaeroLib.LOGGER.error("packet error", t);
                }
            }
        }
    }
}

