/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import xaero.lib.XaeroLib;
import xaero.lib.client.event.ClientEventsForge;
import xaero.lib.client.event.ModClientEventsForge;
import xaero.lib.common.event.CommonEventsForge;
import xaero.lib.common.permission.system.ForgePermissionSystem;
import xaero.lib.common.permission.system.PermissionSystemRegistry;

@Mod(value="xaerolib")
public class XaeroLibForge
extends XaeroLib {
    public Throwable deferredWorkError;
    private CommonEventsForge commonEvents;

    public XaeroLibForge() {
        this.registerEvents();
    }

    private void registerEvents() {
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        context.getModEventBus().addListener(this::loadCommonForge);
        context.getModEventBus().addListener(this::loadClientForge);
        context.getModEventBus().addListener(this::loadServerForge);
        this.commonEvents = new CommonEventsForge();
        MinecraftForge.EVENT_BUS.register((Object)this.commonEvents);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            this.registerClientEvents();
        }
    }

    private void registerClientEvents() {
        ClientEventsForge clientEvents = new ClientEventsForge();
        MinecraftForge.EVENT_BUS.register((Object)clientEvents);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModClientEventsForge(clientEvents));
    }

    private void loadCommonForge(FMLCommonSetupEvent event) {
        this.loadCommon();
    }

    private void loadClientForge(FMLClientSetupEvent event) {
        this.loadClient();
        DeferredWorkQueue.runLater(this::deferredTaskClient);
    }

    private void loadServerForge(FMLDedicatedServerSetupEvent event) {
        this.loadServer();
        DeferredWorkQueue.runLater(this::deferredTaskServer);
    }

    @Override
    public void loadCommonLater() {
        PermissionSystemRegistry.INSTANCE.register(new ForgePermissionSystem());
        super.loadCommonLater();
        ForgePermissionSystem.registerNodes();
    }

    private void deferredTaskClient() {
        try {
            this.loadCommonLater();
            this.loadClientLater();
        }
        catch (Throwable t) {
            this.deferredWorkError = t;
        }
    }

    private void deferredTaskServer() {
        try {
            this.loadCommonLater();
            this.loadServerLater();
        }
        catch (Throwable t) {
            this.deferredWorkError = t;
        }
    }

    public void checkDeferredWorkErrors() {
        if (this.deferredWorkError == null) {
            return;
        }
        if (this.deferredWorkError instanceof RuntimeException) {
            throw (RuntimeException)this.deferredWorkError;
        }
        throw new RuntimeException(this.deferredWorkError);
    }

    public CommonEventsForge getCommonEvents() {
        return this.commonEvents;
    }
}

