/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.controls.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import org.lwjgl.glfw.GLFW;
import xaero.lib.client.controls.util.IKeyMappingHelper;
import xaero.lib.platform.Services;

public class KeyMappingUtils {
    public static boolean inputMatches(InputMappings.Type type, int code, KeyBinding kb, int keyConflictContext) {
        IKeyMappingHelper keyBindingHelper = Services.PLATFORM.getKeyMappingHelper();
        return kb != null && code != -1 && keyBindingHelper.getBoundKeyOf(kb).getType() == type && keyBindingHelper.getBoundKeyOf(kb).getValue() == code && keyBindingHelper.modifiersAreActive(kb, keyConflictContext);
    }

    public static void setKeyState(KeyBinding keyMapping, boolean pressed) {
        KeyBinding.set((InputMappings.Input)Services.PLATFORM.getKeyMappingHelper().getBoundKeyOf(keyMapping), (boolean)pressed);
    }

    public static boolean isPhysicallyDown(KeyBinding keyMapping) {
        IKeyMappingHelper keyBindingHelper = Services.PLATFORM.getKeyMappingHelper();
        if (keyBindingHelper.getBoundKeyOf(keyMapping).getValue() == -1) {
            return false;
        }
        if (keyBindingHelper.getBoundKeyOf(keyMapping).getType() == InputMappings.Type.MOUSE) {
            return GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)keyBindingHelper.getBoundKeyOf(keyMapping).getValue()) == 1;
        }
        if (keyBindingHelper.getBoundKeyOf(keyMapping).getType() == InputMappings.Type.KEYSYM) {
            return InputMappings.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)keyBindingHelper.getBoundKeyOf(keyMapping).getValue());
        }
        return false;
    }

    public static String getKeyName(KeyBinding kb) {
        if (kb == null || Services.PLATFORM.getKeyMappingHelper().getBoundKeyOf(kb).getValue() == -1) {
            return "(unset)";
        }
        return kb.getTranslatedKeyMessage().getString().toUpperCase();
    }
}

