/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class XaeroRenderType
extends RenderType {
    public static final RenderState.DepthTestState GREATER_DEPTH_TEST = new RenderState.DepthTestState(">", 516);
    public static final RenderState.TargetState KEEP_TARGET = new RenderState.TargetState("xaero_keep_target", () -> {}, () -> {});
    public static final RenderState.TransparencyState DEFAULT_TRANSLUCENT_TRANSPARENCY = new RenderState.TransparencyState("xaero_translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderState.TransparencyState LINES_TRANSPARENCY = new RenderState.TransparencyState("xaero_lines_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderState.TransparencyState PREMULTIPLIED_TRANSPARENCY = new RenderState.TransparencyState("xaero_premultiplied_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final RenderState.TransparencyState DEST_TRANSPARENCY = new RenderState.TransparencyState("xaero_destination_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    public static final float DEFAULT_POLYGON_OFFSET = 10.0f;
    public static final RenderState.LayerState DEFAULT_POLYGON_OFFSET_LAYERING = new RenderState.LayerState("xaero_polygon_offset_layering", () -> {
        RenderSystem.polygonOffset((float)0.0f, (float)10.0f);
        RenderSystem.enablePolygonOffset();
    }, () -> {
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
    });
    public static final RenderState.AlphaState ALMOST_ZERO_ALPHA = new RenderState.AlphaState(1.0E-4f);

    private XaeroRenderType(String name, VertexFormat vertexFormat, int drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, Runnable startAction, Runnable endAction) {
        super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, startAction, endAction);
    }

    public static void resetDepthTest() {
        MultiPhaseBuilder.resetDepthTest();
    }

    public static void resetWriteMask() {
        MultiPhaseBuilder.resetWriteMask();
    }

    public static void resetTransparency() {
        MultiPhaseBuilder.resetTransparency();
    }

    public static RenderState.TransparencyState getTransparencyPhase(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        return new RenderState.TransparencyState("xaero_custom_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
    }

    public static class MultiPhaseBuilder
    extends RenderState {
        private RenderState.TextureState texture = RenderState.NO_TEXTURE;
        private RenderState.TransparencyState transparency = RenderState.NO_TRANSPARENCY;
        private RenderState.DiffuseLightingState diffuseLighting = RenderState.NO_DIFFUSE_LIGHTING;
        private RenderState.ShadeModelState shadeModel = RenderState.FLAT_SHADE;
        private RenderState.AlphaState alpha = RenderState.NO_ALPHA;
        private RenderState.DepthTestState depthTest = RenderState.LEQUAL_DEPTH_TEST;
        private RenderState.CullState cull = RenderState.CULL;
        private RenderState.LightmapState lightmap = RenderState.NO_LIGHTMAP;
        private RenderState.OverlayState overlay = RenderState.NO_OVERLAY;
        private RenderState.FogState fog = RenderState.FOG;
        private RenderState.LayerState layering = RenderState.NO_LAYERING;
        private RenderState.TargetState target = RenderState.MAIN_TARGET;
        private RenderState.TexturingState texturing = RenderState.DEFAULT_TEXTURING;
        private RenderState.WriteMaskState writeMaskState = RenderState.COLOR_DEPTH_WRITE;
        private RenderState.LineState lineWidth = RenderState.DEFAULT_LINE;

        public MultiPhaseBuilder() {
            super("weird access error workaround", null, null);
        }

        public MultiPhaseBuilder texture(RenderState.TextureState texture) {
            this.texture = texture;
            return this;
        }

        public MultiPhaseBuilder transparency(RenderState.TransparencyState transparency) {
            this.transparency = transparency;
            return this;
        }

        public MultiPhaseBuilder diffuseLighting(RenderState.DiffuseLightingState diffuseLighting) {
            this.diffuseLighting = diffuseLighting;
            return this;
        }

        public MultiPhaseBuilder shadeModel(RenderState.ShadeModelState shadeModel) {
            this.shadeModel = shadeModel;
            return this;
        }

        public MultiPhaseBuilder alpha(RenderState.AlphaState alpha) {
            this.alpha = alpha;
            return this;
        }

        public MultiPhaseBuilder depthTest(RenderState.DepthTestState depthTest) {
            this.depthTest = depthTest;
            return this;
        }

        public MultiPhaseBuilder cull(RenderState.CullState cull) {
            this.cull = cull;
            return this;
        }

        public MultiPhaseBuilder lightmap(RenderState.LightmapState lightmap) {
            this.lightmap = lightmap;
            return this;
        }

        public MultiPhaseBuilder overlay(RenderState.OverlayState overlay) {
            this.overlay = overlay;
            return this;
        }

        public MultiPhaseBuilder fog(RenderState.FogState fog) {
            this.fog = fog;
            return this;
        }

        public MultiPhaseBuilder layering(RenderState.LayerState layering) {
            this.layering = layering;
            return this;
        }

        public MultiPhaseBuilder target(RenderState.TargetState target) {
            this.target = target;
            return this;
        }

        public MultiPhaseBuilder texturing(RenderState.TexturingState texturing) {
            this.texturing = texturing;
            return this;
        }

        public MultiPhaseBuilder writeMaskState(RenderState.WriteMaskState writeMaskState) {
            this.writeMaskState = writeMaskState;
            return this;
        }

        public MultiPhaseBuilder lineWidth(RenderState.LineState lineWidth) {
            this.lineWidth = lineWidth;
            return this;
        }

        public ImmutableList<RenderState> build() {
            return ImmutableList.of((Object)this.texture, (Object)this.transparency, (Object)this.diffuseLighting, (Object)this.shadeModel, (Object)this.alpha, (Object)this.depthTest, (Object)this.cull, (Object)this.lightmap, (Object)this.overlay, (Object)this.fog, (Object)this.layering, (Object)this.target, (Object[])new RenderState[]{this.texturing, this.writeMaskState, this.lineWidth});
        }

        public static void resetDepthTest() {
            RenderState.EQUAL_DEPTH_TEST.setupRenderState();
            RenderState.EQUAL_DEPTH_TEST.clearRenderState();
        }

        public static void resetWriteMask() {
            RenderState.COLOR_WRITE.setupRenderState();
            RenderState.COLOR_WRITE.clearRenderState();
            RenderState.DEPTH_WRITE.setupRenderState();
            RenderState.DEPTH_WRITE.clearRenderState();
        }

        public static void resetTransparency() {
            RenderState.ADDITIVE_TRANSPARENCY.setupRenderState();
            RenderState.ADDITIVE_TRANSPARENCY.clearRenderState();
        }
    }

    public static class MultiPhaseRenderType
    extends RenderType {
        public MultiPhaseRenderType(String name, VertexFormat vertexFormat, int drawMode, int expectedBufferSize, boolean hasCrumbling, boolean translucent, ImmutableList<RenderState> phases) {
            super(name, vertexFormat, drawMode, expectedBufferSize, hasCrumbling, translucent, () -> phases.forEach(RenderState::setupRenderState), () -> phases.forEach(RenderState::clearRenderState));
        }
    }
}

