/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.graphics.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;

public class ImmediateRenderUtil {
    public static void coloredRectangle(MatrixStack matrices, float x1, float y1, float x2, float y2, int color) {
        ImmediateRenderUtil.coloredRectangle(matrices.last().pose(), x1, y1, x2, y2, color);
    }

    public static void coloredRectangle(Matrix4f matrix, float x1, float y1, float x2, float y2, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexBuffer = tessellator.getBuilder();
        vertexBuffer.begin(7, DefaultVertexFormats.POSITION_COLOR);
        vertexBuffer.vertex(matrix, x1, y2, 0.0f).color(r, g, b, a).endVertex();
        vertexBuffer.vertex(matrix, x2, y2, 0.0f).color(r, g, b, a).endVertex();
        vertexBuffer.vertex(matrix, x2, y1, 0.0f).color(r, g, b, a).endVertex();
        vertexBuffer.vertex(matrix, x1, y1, 0.0f).color(r, g, b, a).endVertex();
        tessellator.end();
    }

    public static void texturedRect(MatrixStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        ImmediateRenderUtil.texturedRect(matrixStack, x, y, textureX, textureY, width, height, theight, factor, 0.0f, true);
    }

    public static void texturedRect(MatrixStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor, float discardAlpha, boolean blend) {
        if (discardAlpha < 0.0f) {
            GlStateManager._disableAlphaTest();
        } else {
            GlStateManager._enableAlphaTest();
            GlStateManager._alphaFunc((int)516, (float)discardAlpha);
        }
        if (blend) {
            GlStateManager._enableBlend();
        } else {
            GlStateManager._disableBlend();
        }
        ImmediateRenderUtil.texturedRectInternal(matrixStack, x, y, textureX, textureY, width, height, theight, factor);
        GlStateManager._enableBlend();
        GlStateManager._enableAlphaTest();
        GlStateManager._alphaFunc((int)516, (float)0.1f);
    }

    private static void texturedRectInternal(MatrixStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float textureH, float factor) {
        float f;
        float f1 = f = 1.0f / factor;
        Matrix4f matrix = matrixStack.last().pose();
        Tessellator tessellator = Tessellator.getInstance();
        BufferBuilder vertexBuffer = tessellator.getBuilder();
        vertexBuffer.begin(7, DefaultVertexFormats.POSITION_TEX);
        vertexBuffer.vertex(matrix, x + 0.0f, y + height, 0.0f).uv((float)(textureX + 0) * f, (float)(textureY + 0) * f1).endVertex();
        vertexBuffer.vertex(matrix, x + width, y + height, 0.0f).uv(((float)textureX + width) * f, (float)(textureY + 0) * f1).endVertex();
        vertexBuffer.vertex(matrix, x + width, y + 0.0f, 0.0f).uv(((float)textureX + width) * f, ((float)textureY + textureH) * f1).endVertex();
        vertexBuffer.vertex(matrix, x + 0.0f, y + 0.0f, 0.0f).uv((float)(textureX + 0) * f, ((float)textureY + textureH) * f1).endVertex();
        tessellator.end();
    }

    public static void drawOutlineLayer(MatrixStack matrixStack, float x, float y, int textureX, int textureY, float width, float height, float theight, float factor) {
        ImmediateRenderUtil.texturedRectInternal(matrixStack, x, y, textureX, textureY, width, height, theight, factor);
        GlStateManager._enableAlphaTest();
        GlStateManager._alphaFunc((int)516, (float)0.1f);
    }
}

