/*
 * Decompiled with CFR 0.152.
 */
package xaero.lib.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.glfw.GLFW;
import xaero.lib.XaeroLib;
import xaero.lib.client.gui.IScreenBase;
import xaero.lib.client.gui.widget.ITooltipHaver;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;

public class ScreenBase
extends Screen
implements IScreenBase {
    public Screen parent;
    public Screen escape;
    protected boolean canSkipWorldRender;
    protected DropDownWidget openDropdown;
    private List<DropDownWidget> dropdowns;
    protected boolean shouldRefresh;

    protected ScreenBase(Screen parent, Screen escape, ITextComponent titleIn) {
        super(titleIn);
        this.parent = parent;
        this.escape = escape;
        this.dropdowns = new ArrayList<DropDownWidget>();
    }

    public void onExit(Screen screen) {
        this.minecraft.setScreen(screen);
    }

    public void goBack() {
        this.onExit(this.parent);
    }

    public void onClose() {
        this.onExit(this.escape);
    }

    public void renderEscapeScreen(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        if (this.escape != null) {
            this.escape.render(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
            GlStateManager._clear((int)256, (boolean)Minecraft.ON_OSX);
        }
    }

    public void renderBackground(MatrixStack poseStack) {
        this.handleRefresh();
        super.renderBackground(poseStack);
    }

    public void render(MatrixStack poseStack, int mouseX, int mouseY, float partial) {
        this.handleRefresh();
        super.render(poseStack, mouseX, mouseY, partial);
        this.renderPreDropdown(poseStack, mouseX, mouseY, partial);
        for (DropDownWidget dropdown : this.dropdowns) {
            dropdown.render(poseStack, mouseX, mouseY, partial);
        }
        if (this.openDropdown != null) {
            poseStack.pushPose();
            poseStack.translate(0.0, 0.0, 2.0);
            this.openDropdown.render(poseStack, mouseX, mouseY, this.height, false);
            poseStack.popPose();
        }
    }

    protected void renderPreDropdown(MatrixStack poseStack, int mouseX, int mouseY, float partial) {
    }

    protected void init() {
        super.init();
        this.dropdowns.clear();
        this.openDropdown = null;
    }

    public void init(Minecraft p_231158_1_, int p_231158_2_, int p_231158_3_) {
        super.init(p_231158_1_, p_231158_2_, p_231158_3_);
        if (this.escape != null) {
            this.escape.init(p_231158_1_, p_231158_2_, p_231158_3_);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.openDropdown != null) {
            if (!this.openDropdown.onDropDown((int)mouseX, (int)mouseY, this.height)) {
                this.openDropdown.setClosed(true);
                this.openDropdown = null;
            } else {
                this.openDropdown.mouseClicked(mouseX, mouseY, button);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double wheel) {
        if (this.openDropdown != null) {
            if (this.openDropdown.onDropDown((int)mouseX, (int)mouseY, this.height)) {
                return this.openDropdown.mouseScrolled(mouseX, mouseY, wheel);
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, wheel);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.openDropdown != null && this.openDropdown.mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    public boolean shouldSkipWorldRender() {
        return this.canSkipWorldRender && this.escape instanceof IScreenBase && ((IScreenBase)this.escape).shouldSkipWorldRender();
    }

    protected boolean renderTooltips(MatrixStack matrixStack, int par1, int par2, float par3) {
        matrixStack.pushPose();
        matrixStack.translate(0.0, 0.0, 2.1);
        boolean result = XaeroLib.INSTANCE.getClient().getWidgetScreenHandler().renderTooltips(matrixStack, this, this.width, this.height, par1, par2, this.minecraft.getWindow().getGuiScale());
        boolean mousePressed = GLFW.glfwGetMouseButton((long)this.minecraft.getWindow().getWindow(), (int)0) == 1;
        for (int k = 0; k < this.buttons.size(); ++k) {
            Tooltip tooltip;
            Widget b = (Widget)this.buttons.get(k);
            if (!(b instanceof ITooltipHaver) || b instanceof AbstractSlider && mousePressed) continue;
            ITooltipHaver optionWidget = (ITooltipHaver)b;
            if (par1 < b.x || par2 < b.y || par1 >= b.x + b.getWidth() || par2 >= b.y + b.getHeight() || optionWidget.getXaero_tooltip() == null || (tooltip = optionWidget.getXaero_tooltip().get()) == null) continue;
            tooltip.drawBox(matrixStack, par1, par2, this.width, this.height);
            result = true;
            break;
        }
        matrixStack.popPose();
        return result;
    }

    @Override
    public void onDropdownOpen(DropDownWidget menu) {
        if (this.openDropdown != null && this.openDropdown != menu) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = menu;
    }

    @Override
    public void onDropdownClosed(DropDownWidget menu) {
        if (menu != this.openDropdown && this.openDropdown != null) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = null;
    }

    protected <T extends IGuiEventListener> T addWidget(T guiEventListener) {
        if (guiEventListener instanceof DropDownWidget) {
            this.dropdowns.add((DropDownWidget)guiEventListener);
        }
        return (T)super.addWidget(guiEventListener);
    }

    private void handleDropdownReplacement(Widget current, Widget replacement) {
        int dropdownIndex = this.dropdowns.indexOf(current);
        if (dropdownIndex != -1) {
            this.dropdowns.set(dropdownIndex, (DropDownWidget)replacement);
        }
    }

    public void replaceWidget(Widget current, Widget replacement) {
        int buttonIndex;
        int childIndex = this.children.indexOf(current);
        if (childIndex != -1) {
            this.children.set(childIndex, replacement);
        }
        if ((buttonIndex = this.buttons.indexOf(current)) != -1) {
            this.buttons.set(buttonIndex, replacement);
        }
        this.handleDropdownReplacement(current, replacement);
        if (this.getFocused() == current) {
            this.setFocused((IGuiEventListener)replacement);
        }
    }

    public void removeWidget(Widget current) {
        this.children.remove(current);
        this.buttons.remove(current);
        this.dropdowns.remove(current);
    }

    @Override
    public Screen getEscape() {
        return this.escape;
    }

    public static Screen tryToGetEscape(Screen screen) {
        if (screen instanceof IScreenBase) {
            return ((IScreenBase)screen).getEscape();
        }
        return null;
    }

    public void refresh() {
        this.shouldRefresh = true;
    }

    protected final void handleRefresh() {
        if (!this.shouldRefresh) {
            return;
        }
        this.shouldRefresh = false;
        int focusedIndex = this.getIndex(this.getFocused());
        this.init(this.minecraft, this.width, this.height);
        this.restoreFocus(focusedIndex);
    }

    public void restoreFocus(int index) {
        if (index != -1) {
            try {
                IGuiEventListener child = (IGuiEventListener)this.children.get(index);
                this.setFocused(child);
                child.changeFocus(true);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    public int getIndex(IGuiEventListener child) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) != child) continue;
            return i;
        }
        return -1;
    }

    public boolean canSkipWorldRender() {
        return this.canSkipWorldRender;
    }
}

